/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.docs;

import java.util.Objects;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;

class ImmutableAssertingSpan
implements AssertingSpan {
    private final DocumentedSpan documentedSpan;
    private final Span delegate;
    boolean isStarted;

    ImmutableAssertingSpan(DocumentedSpan documentedSpan, Span delegate) {
        Objects.requireNonNull(documentedSpan);
        Objects.requireNonNull(delegate);
        this.documentedSpan = documentedSpan;
        this.delegate = delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAssertingSpan that = (ImmutableAssertingSpan)o;
        return Objects.equals(this.documentedSpan, that.documentedSpan) && Objects.equals(this.delegate, that.delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int hashCode() {
        return Objects.hash(this.documentedSpan, this.delegate);
    }

    @Override
    public DocumentedSpan getDocumentedSpan() {
        return this.documentedSpan;
    }

    @Override
    public Span getDelegate() {
        return this.delegate;
    }

    @Override
    public AssertingSpan start() {
        this.isStarted = true;
        return AssertingSpan.super.start();
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }
}

