/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.autoconfigure.LifecycleMvcEndpointAutoConfiguration;
import org.springframework.cloud.autoconfigure.PauseResumeEndpointsConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RestartEndpointWithIntegrationConfiguration;
import org.springframework.cloud.autoconfigure.RestartEndpointWithoutIntegrationConfiguration;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapConfiguration;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.cloud.health.RefreshScopeHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EndpointAutoConfiguration.class, Health.class})
@AutoConfigureAfter(value={LifecycleMvcEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
@Import(value={RestartEndpointWithIntegrationConfiguration.class, RestartEndpointWithoutIntegrationConfiguration.class, PauseResumeEndpointsConfiguration.class})
public class RefreshEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledHealthIndicator(value="refresh")
    RefreshScopeHealthIndicator refreshScopeHealthIndicator(ObjectProvider<RefreshScope> scope, ConfigurationPropertiesRebinder rebinder) {
        return new RefreshScopeHealthIndicator(scope, rebinder);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={PropertySourceBootstrapConfiguration.class})
    protected static class RefreshEndpointConfiguration {
        protected RefreshEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ContextRefresher.class})
        @ConditionalOnAvailableEndpoint
        @ConditionalOnMissingBean
        public RefreshEndpoint refreshEndpoint(ContextRefresher contextRefresher) {
            return new RefreshEndpoint(contextRefresher);
        }
    }
}

