/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

class InvalidConfigurationPropertyValueFailureAnalyzer
extends AbstractFailureAnalyzer<InvalidConfigurationPropertyValueException>
implements EnvironmentAware {
    private ConfigurableEnvironment environment;

    InvalidConfigurationPropertyValueFailureAnalyzer() {
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, InvalidConfigurationPropertyValueException cause) {
        List<Descriptor> descriptors = this.getDescriptors(cause.getName());
        if (descriptors.isEmpty()) {
            return null;
        }
        StringBuilder description = new StringBuilder();
        this.appendDetails(description, cause, descriptors);
        this.appendReason(description, cause);
        this.appendAdditionalProperties(description, descriptors);
        return new FailureAnalysis(description.toString(), this.getAction(cause), cause);
    }

    private List<Descriptor> getDescriptors(String propertyName) {
        return this.getPropertySources().filter(source -> source.containsProperty(propertyName)).map(source -> Descriptor.get(source, propertyName)).collect(Collectors.toList());
    }

    private Stream<PropertySource<?>> getPropertySources() {
        MutablePropertySources sources = this.environment == null ? Collections.emptyList() : this.environment.getPropertySources();
        return StreamSupport.stream(sources.spliterator(), false).filter(source -> !ConfigurationPropertySources.isAttachedConfigurationPropertySource(source));
    }

    private void appendDetails(StringBuilder message, InvalidConfigurationPropertyValueException cause, List<Descriptor> descriptors) {
        Descriptor mainDescriptor = descriptors.get(0);
        message.append("Invalid value '" + mainDescriptor.getValue() + "' for configuration property '" + cause.getName() + "'");
        mainDescriptor.appendOrigin(message);
        message.append(".");
    }

    private void appendReason(StringBuilder message, InvalidConfigurationPropertyValueException cause) {
        if (StringUtils.hasText((String)cause.getReason())) {
            message.append(String.format(" Validation failed for the following reason:%n%n", new Object[0]));
            message.append(cause.getReason());
        } else {
            message.append(" No reason was provided.");
        }
    }

    private void appendAdditionalProperties(StringBuilder message, List<Descriptor> descriptors) {
        List<Descriptor> others = descriptors.subList(1, descriptors.size());
        if (!others.isEmpty()) {
            message.append(String.format("%n%nAdditionally, this property is also set in the following property %s:%n%n", others.size() > 1 ? "sources" : "source"));
            for (Descriptor other : others) {
                message.append("\t- In '" + other.getPropertySource() + "'");
                message.append(" with the value '" + other.getValue() + "'");
                other.appendOrigin(message);
                message.append(String.format(".%n", new Object[0]));
            }
        }
    }

    private String getAction(InvalidConfigurationPropertyValueException cause) {
        StringBuilder action = new StringBuilder();
        action.append("Review the value of the property");
        if (cause.getReason() != null) {
            action.append(" with the provided reason");
        }
        action.append(".");
        return action.toString();
    }

    private static final class Descriptor {
        private final String propertySource;
        private final Object value;
        private final Origin origin;

        private Descriptor(String propertySource, Object value, Origin origin) {
            this.propertySource = propertySource;
            this.value = value;
            this.origin = origin;
        }

        public String getPropertySource() {
            return this.propertySource;
        }

        public Object getValue() {
            return this.value;
        }

        public void appendOrigin(StringBuilder message) {
            if (this.origin != null) {
                message.append(" (originating from '" + this.origin + "')");
            }
        }

        static Descriptor get(PropertySource<?> source, String propertyName) {
            Object value = source.getProperty(propertyName);
            Origin origin = OriginLookup.getOrigin(source, propertyName);
            return new Descriptor(source.getName(), value, origin);
        }
    }
}

