/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.JsonLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class BasicJsonTester {
    private @Nullable JsonLoader loader;

    protected BasicJsonTester() {
    }

    public BasicJsonTester(Class<?> resourceLoadClass) {
        this(resourceLoadClass, null);
    }

    public BasicJsonTester(Class<?> resourceLoadClass, @Nullable Charset charset) {
        Assert.notNull(resourceLoadClass, (String)"'resourceLoadClass' must not be null");
        this.loader = new JsonLoader(resourceLoadClass, charset);
    }

    protected final void initialize(Class<?> resourceLoadClass) {
        this.initialize(resourceLoadClass, null);
    }

    protected final void initialize(Class<?> resourceLoadClass, @Nullable Charset charset) {
        if (this.loader == null) {
            this.loader = new JsonLoader(resourceLoadClass, charset);
        }
    }

    public JsonContent<Object> from(CharSequence source) {
        JsonLoader loader = this.verify();
        return this.getJsonContent(loader, loader.getJson(source));
    }

    public JsonContent<Object> from(String path, Class<?> resourceLoadClass) {
        JsonLoader loader = this.verify();
        return this.getJsonContent(loader, loader.getJson(path, resourceLoadClass));
    }

    public JsonContent<Object> from(byte[] source) {
        JsonLoader loader = this.verify();
        return this.getJsonContent(loader, loader.getJson(source));
    }

    public JsonContent<Object> from(File source) {
        JsonLoader loader = this.verify();
        return this.getJsonContent(loader, loader.getJson(source));
    }

    public JsonContent<Object> from(InputStream source) {
        JsonLoader loader = this.verify();
        return this.getJsonContent(loader, loader.getJson(source));
    }

    public JsonContent<Object> from(Resource source) {
        JsonLoader loader = this.verify();
        return this.getJsonContent(loader, loader.getJson(source));
    }

    private JsonLoader verify() {
        Assert.state((this.loader != null ? 1 : 0) != 0, (String)"Uninitialized BasicJsonTester");
        return this.loader;
    }

    private JsonContent<Object> getJsonContent(JsonLoader loader, String json) {
        return new JsonContent<Object>(loader.getResourceLoadClass(), null, json);
    }
}

