/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.web.util.UriTemplateHandler;

class TestRestTemplateContextCustomizer
implements ContextCustomizer {
    TestRestTemplateContextCustomizer() {
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)mergedContextConfiguration.getTestClass(), SpringBootTest.class);
        if (annotation.webEnvironment().isEmbedded()) {
            this.registerTestRestTemplate(context);
        }
    }

    private void registerTestRestTemplate(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerTestRestTemplate((BeanDefinitionRegistry)context);
        }
    }

    private void registerTestRestTemplate(BeanDefinitionRegistry registry) {
        RootBeanDefinition definition = new RootBeanDefinition(TestRestTemplateRegistrar.class);
        definition.setRole(2);
        registry.registerBeanDefinition(TestRestTemplateRegistrar.class.getName(), (BeanDefinition)definition);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class TestRestTemplateFactory
    implements FactoryBean<TestRestTemplate>,
    ApplicationContextAware {
        private static final TestRestTemplate.HttpClientOption[] DEFAULT_OPTIONS = new TestRestTemplate.HttpClientOption[0];
        private static final TestRestTemplate.HttpClientOption[] SSL_OPTIONS = new TestRestTemplate.HttpClientOption[]{TestRestTemplate.HttpClientOption.SSL};
        private TestRestTemplate template;

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            RestTemplateBuilder builder = this.getRestTemplateBuilder(applicationContext);
            boolean sslEnabled = this.isSslEnabled(applicationContext);
            TestRestTemplate template = new TestRestTemplate(builder, null, null, sslEnabled ? SSL_OPTIONS : DEFAULT_OPTIONS);
            LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler(applicationContext.getEnvironment(), sslEnabled ? "https" : "http");
            template.setUriTemplateHandler((UriTemplateHandler)handler);
            this.template = template;
        }

        private boolean isSslEnabled(ApplicationContext context) {
            try {
                AbstractServletWebServerFactory webServerFactory = (AbstractServletWebServerFactory)context.getBean(AbstractServletWebServerFactory.class);
                return webServerFactory.getSsl() != null && webServerFactory.getSsl().isEnabled();
            }
            catch (NoSuchBeanDefinitionException ex) {
                return false;
            }
        }

        private RestTemplateBuilder getRestTemplateBuilder(ApplicationContext applicationContext) {
            try {
                return (RestTemplateBuilder)applicationContext.getBean(RestTemplateBuilder.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return new RestTemplateBuilder(new RestTemplateCustomizer[0]);
            }
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<?> getObjectType() {
            return TestRestTemplate.class;
        }

        public TestRestTemplate getObject() throws Exception {
            return this.template;
        }
    }

    private static class TestRestTemplateRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    Ordered,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        private TestRestTemplateRegistrar() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), TestRestTemplate.class).length == 0) {
                registry.registerBeanDefinition(TestRestTemplate.class.getName(), (BeanDefinition)new RootBeanDefinition(TestRestTemplateFactory.class));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

