/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;

public class ArtifactsLibraries
implements Libraries {
    private static final Map<String, LibraryScope> SCOPES;
    private final Set<Artifact> artifacts;
    private final Collection<Dependency> unpacks;
    private final Log log;

    public ArtifactsLibraries(Set<Artifact> artifacts, Collection<Dependency> unpacks, Log log) {
        this.artifacts = artifacts;
        this.unpacks = unpacks;
        this.log = log;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Set<String> duplicates = this.getDuplicates(this.artifacts);
        for (Artifact artifact : this.artifacts) {
            LibraryScope scope = SCOPES.get(artifact.getScope());
            if (scope == null || artifact.getFile() == null) continue;
            String name = artifact.getFile().getName();
            if (duplicates.contains(name)) {
                this.log.debug((CharSequence)("Duplicate found: " + name));
                name = artifact.getGroupId() + "-" + name;
                this.log.debug((CharSequence)("Renamed to: " + name));
            }
            callback.library(new Library(name, artifact.getFile(), scope, this.isUnpackRequired(artifact)));
        }
    }

    private Set<String> getDuplicates(Set<Artifact> artifacts) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || seen.add(artifact.getFile().getName())) continue;
            duplicates.add(artifact.getFile().getName());
        }
        return duplicates;
    }

    private boolean isUnpackRequired(Artifact artifact) {
        if (this.unpacks != null) {
            for (Dependency unpack : this.unpacks) {
                if (!artifact.getGroupId().equals(unpack.getGroupId()) || !artifact.getArtifactId().equals(unpack.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashMap<String, LibraryScope> scopes = new HashMap<String, LibraryScope>();
        scopes.put("compile", LibraryScope.COMPILE);
        scopes.put("runtime", LibraryScope.RUNTIME);
        scopes.put("provided", LibraryScope.PROVIDED);
        SCOPES = Collections.unmodifiableMap(scopes);
    }
}

