/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.InvalidConfigurationMetadataException;
import org.springframework.boot.configurationprocessor.metadata.JsonMarshaller;

public class MetadataStore {
    static final String METADATA_PATH = "META-INF/spring-configuration-metadata.json";
    private static final String ADDITIONAL_METADATA_PATH = "META-INF/additional-spring-configuration-metadata.json";
    private static final String RESOURCES_FOLDER = "resources";
    private static final String CLASSES_FOLDER = "classes";
    private final ProcessingEnvironment environment;

    public MetadataStore(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    public ConfigurationMetadata readMetadata() {
        try {
            return this.readMetadata(this.getMetadataResource().openInputStream());
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void writeMetadata(ConfigurationMetadata metadata) throws IOException {
        if (!metadata.getItems().isEmpty()) {
            OutputStream outputStream = this.createMetadataResource().openOutputStream();
            try {
                new JsonMarshaller().write(metadata, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
    }

    public ConfigurationMetadata readAdditionalMetadata() throws IOException {
        return this.readMetadata(this.getAdditionalMetadataStream());
    }

    private ConfigurationMetadata readMetadata(InputStream in) throws IOException {
        try {
            ConfigurationMetadata configurationMetadata = new JsonMarshaller().read(in);
            return configurationMetadata;
        }
        catch (IOException ex) {
            ConfigurationMetadata configurationMetadata = null;
            return configurationMetadata;
        }
        catch (Exception ex) {
            throw new InvalidConfigurationMetadataException("Invalid additional meta-data in 'META-INF/spring-configuration-metadata.json': " + ex.getMessage(), Diagnostic.Kind.ERROR);
        }
        finally {
            in.close();
        }
    }

    private FileObject getMetadataResource() throws IOException {
        FileObject resource = this.environment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", METADATA_PATH);
        return resource;
    }

    private FileObject createMetadataResource() throws IOException {
        FileObject resource = this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", METADATA_PATH, new Element[0]);
        return resource;
    }

    private InputStream getAdditionalMetadataStream() throws IOException {
        String path;
        int index;
        FileObject fileObject = this.environment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", ADDITIONAL_METADATA_PATH);
        File file = new File(fileObject.toUri());
        if (!file.exists() && (index = (path = file.getPath()).lastIndexOf(CLASSES_FOLDER)) >= 0) {
            path = path.substring(0, index) + RESOURCES_FOLDER + path.substring(index + CLASSES_FOLDER.length());
            file = new File(path);
        }
        return file.exists() ? new FileInputStream(file) : fileObject.toUri().toURL().openStream();
    }
}

