/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.configuration.Credential;
import org.springframework.boot.buildpack.platform.docker.configuration.CredentialHelper;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfigurationMetadata;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryAuthentication;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.system.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DockerRegistryConfigAuthentication
implements DockerRegistryAuthentication {
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String INDEX_URL = "https://index.docker.io/v1/";
    static Map<String, Credential> credentialFromHelperCache = new ConcurrentHashMap<String, Credential>();
    private final @Nullable DockerRegistryAuthentication fallback;
    private final BiConsumer<String, Exception> credentialHelperExceptionHandler;
    private final Function<String, @Nullable CredentialHelper> credentialHelperFactory;
    private final DockerConfigurationMetadata.DockerConfig dockerConfig;

    DockerRegistryConfigAuthentication(@Nullable DockerRegistryAuthentication fallback, BiConsumer<String, Exception> credentialHelperExceptionHandler) {
        this(fallback, credentialHelperExceptionHandler, Environment.SYSTEM, helper -> new CredentialHelper("docker-credential-" + helper));
    }

    DockerRegistryConfigAuthentication(@Nullable DockerRegistryAuthentication fallback, BiConsumer<String, Exception> credentialHelperExceptionHandler, Environment environment, Function<String, @Nullable CredentialHelper> credentialHelperFactory) {
        this.fallback = fallback;
        this.credentialHelperExceptionHandler = credentialHelperExceptionHandler;
        this.dockerConfig = DockerConfigurationMetadata.from(environment).getConfiguration();
        this.credentialHelperFactory = credentialHelperFactory;
    }

    @Override
    public @Nullable String getAuthHeader() {
        return this.getAuthHeader(null);
    }

    @Override
    public @Nullable String getAuthHeader(@Nullable ImageReference imageReference) {
        String serverUrl = this.getServerUrl(imageReference);
        DockerRegistryAuthentication authentication = this.getAuthentication(serverUrl);
        return authentication != null ? authentication.getAuthHeader(imageReference) : null;
    }

    private @Nullable String getServerUrl(@Nullable ImageReference imageReference) {
        String domain = imageReference != null ? imageReference.getDomain() : null;
        return !DEFAULT_DOMAIN.equals(domain) ? domain : INDEX_URL;
    }

    private @Nullable DockerRegistryAuthentication getAuthentication(@Nullable String serverUrl) {
        DockerConfigurationMetadata.Auth authConfig;
        Credential credentialsFromHelper = this.getCredentialsFromHelper(serverUrl);
        Map.Entry<String, DockerConfigurationMetadata.Auth> authConfigEntry = this.getAuthConfigEntry(serverUrl);
        DockerConfigurationMetadata.Auth auth = authConfig = authConfigEntry != null ? authConfigEntry.getValue() : null;
        if (credentialsFromHelper != null) {
            return this.getAuthentication(credentialsFromHelper, authConfig, serverUrl);
        }
        if (authConfig != null) {
            Assert.state((authConfigEntry != null ? 1 : 0) != 0, (String)"'authConfigEntry' must not be null");
            String username = authConfig.getUsername();
            String password = authConfig.getPassword();
            Assert.state((username != null ? 1 : 0) != 0, (String)"'username' must not be null");
            Assert.state((password != null ? 1 : 0) != 0, (String)"'password' must not be null");
            return DockerRegistryAuthentication.user(username, password, authConfigEntry.getKey(), authConfig.getEmail());
        }
        return this.fallback;
    }

    private DockerRegistryAuthentication getAuthentication(Credential credentialsFromHelper, @Nullable DockerConfigurationMetadata.Auth authConfig, @Nullable String serverUrl) {
        if (credentialsFromHelper.isIdentityToken()) {
            return DockerRegistryAuthentication.token(credentialsFromHelper.getSecret());
        }
        String username = credentialsFromHelper.getUsername();
        String password = credentialsFromHelper.getSecret();
        String serverAddress = StringUtils.hasLength((String)credentialsFromHelper.getServerUrl()) ? credentialsFromHelper.getServerUrl() : serverUrl;
        String email = authConfig != null ? authConfig.getEmail() : null;
        return DockerRegistryAuthentication.user(username, password, serverAddress, email);
    }

    private @Nullable Credential getCredentialsFromHelper(@Nullable String serverUrl) {
        return StringUtils.hasLength((String)serverUrl) ? credentialFromHelperCache.computeIfAbsent(serverUrl, this::computeCredentialsFromHelper) : null;
    }

    private @Nullable Credential computeCredentialsFromHelper(String serverUrl) {
        CredentialHelper credentialHelper = this.getCredentialHelper(serverUrl);
        if (credentialHelper != null) {
            try {
                return credentialHelper.get(serverUrl);
            }
            catch (Exception ex) {
                String message = "Error retrieving credentials for '%s' due to: %s".formatted(serverUrl, ex.getMessage());
                this.credentialHelperExceptionHandler.accept(message, ex);
            }
        }
        return null;
    }

    private @Nullable CredentialHelper getCredentialHelper(String serverUrl) {
        String name = this.dockerConfig.getCredHelpers().getOrDefault(serverUrl, this.dockerConfig.getCredsStore());
        return StringUtils.hasLength((String)name) ? this.credentialHelperFactory.apply(name) : null;
    }

    private @Nullable Map.Entry<String, DockerConfigurationMetadata.Auth> getAuthConfigEntry(@Nullable String serverUrl) {
        if (serverUrl == null) {
            return null;
        }
        for (Map.Entry<String, DockerConfigurationMetadata.Auth> candidate : this.dockerConfig.getAuths().entrySet()) {
            if (!candidate.getKey().equals(serverUrl) && !candidate.getKey().endsWith("://" + serverUrl)) continue;
            return candidate;
        }
        return null;
    }
}

