/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hc.core5.http.Header;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.transport.LocalHttpClientTransport;
import org.springframework.boot.buildpack.platform.docker.transport.RemoteHttpClientTransport;
import org.springframework.boot.buildpack.platform.io.IOConsumer;

public interface HttpTransport {
    public Response get(URI var1) throws IOException;

    public Response post(URI var1) throws IOException;

    public Response post(URI var1, String var2) throws IOException;

    public Response post(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response put(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response delete(URI var1) throws IOException;

    public Response head(URI var1) throws IOException;

    public static HttpTransport create(DockerConfiguration.DockerHostConfiguration dockerHost) {
        ResolvedDockerHost host = ResolvedDockerHost.from(dockerHost);
        RemoteHttpClientTransport remote = RemoteHttpClientTransport.createIfPossible(host);
        return remote != null ? remote : LocalHttpClientTransport.create(host);
    }

    public static interface Response
    extends Closeable {
        public InputStream getContent() throws IOException;

        default public Header getHeader(String name) {
            throw new UnsupportedOperationException();
        }
    }
}

