/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import io.undertow.Undertow;
import org.apache.catalina.startup.Tomcat;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.embedded.jetty.JettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatReactiveWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowReactiveWebServerFactory;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.ipc.netty.http.server.HttpServer;

abstract class ReactiveWebServerFactoryConfiguration {
    ReactiveWebServerFactoryConfiguration() {
    }

    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    @ConditionalOnClass(value={Undertow.class})
    static class EmbeddedUndertow {
        EmbeddedUndertow() {
        }

        @Bean
        public UndertowReactiveWebServerFactory undertowReactiveWebServerFactory() {
            return new UndertowReactiveWebServerFactory();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    @ConditionalOnClass(value={Server.class})
    static class EmbeddedJetty {
        EmbeddedJetty() {
        }

        @Bean
        public JettyReactiveWebServerFactory jettyReactiveWebServerFactory() {
            return new JettyReactiveWebServerFactory();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    @ConditionalOnClass(value={Tomcat.class})
    static class EmbeddedTomcat {
        EmbeddedTomcat() {
        }

        @Bean
        public TomcatReactiveWebServerFactory tomcatReactiveWebServerFactory() {
            return new TomcatReactiveWebServerFactory();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    @ConditionalOnClass(value={HttpServer.class})
    static class EmbeddedNetty {
        EmbeddedNetty() {
        }

        @Bean
        public NettyReactiveWebServerFactory NettyReactiveWebServerFactory() {
            return new NettyReactiveWebServerFactory();
        }
    }
}

