/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public final class EndpointId {
    private static final Pattern VALID_CHARS = Pattern.compile("[a-zA-Z0-9\\.\\-]+");
    private final String value;
    private final String lowerCaseValue;
    private final String lowerCaseAlphaNumeric;

    private EndpointId(String value) {
        Assert.hasText((String)value, (String)"Value must not be empty");
        Assert.isTrue((boolean)VALID_CHARS.matcher(value).matches(), (String)"Value must only contain valid chars");
        Assert.isTrue((!Character.isDigit(value.charAt(0)) ? 1 : 0) != 0, (String)"Value must not start with a number");
        Assert.isTrue((!Character.isUpperCase(value.charAt(0)) ? 1 : 0) != 0, (String)"Value must not start with an uppercase letter");
        this.value = value;
        this.lowerCaseValue = value.toLowerCase(Locale.ENGLISH);
        this.lowerCaseAlphaNumeric = this.getAlphaNumerics(this.lowerCaseValue);
    }

    private String getAlphaNumerics(String value) {
        StringBuilder result = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if ((ch < 'a' || ch > 'z') && (ch < '0' || ch > '9')) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.lowerCaseAlphaNumeric.equals(((EndpointId)obj).lowerCaseAlphaNumeric);
    }

    public int hashCode() {
        return this.lowerCaseAlphaNumeric.hashCode();
    }

    public String toLowerCaseString() {
        return this.lowerCaseValue;
    }

    public String toString() {
        return this.value;
    }

    public static EndpointId of(String value) {
        return new EndpointId(value);
    }

    public static EndpointId fromPropertyValue(String value) {
        return new EndpointId(value.replace("-", ""));
    }
}

