/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.AbstractEndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorGetMapping;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(prefix="endpoints.health")
public class HealthMvcEndpoint
extends AbstractEndpointMvcAdapter<HealthEndpoint>
implements EnvironmentAware {
    private final boolean secure;
    private final List<String> roles;
    private volatile CachedHealth cachedHealth;
    private Map<String, HttpStatus> statusMapping = new HashMap<String, HttpStatus>();
    private RelaxedPropertyResolver securityPropertyResolver;

    public HealthMvcEndpoint(HealthEndpoint delegate) {
        this(delegate, true);
    }

    public HealthMvcEndpoint(HealthEndpoint delegate, boolean secure) {
        this(delegate, secure, null);
    }

    public HealthMvcEndpoint(HealthEndpoint delegate, boolean secure, List<String> roles) {
        super(delegate);
        this.secure = secure;
        this.setupDefaultStatusMapping();
        this.roles = roles;
    }

    private void setupDefaultStatusMapping() {
        this.addStatusMapping(Status.DOWN, HttpStatus.SERVICE_UNAVAILABLE);
        this.addStatusMapping(Status.OUT_OF_SERVICE, HttpStatus.SERVICE_UNAVAILABLE);
    }

    public void setEnvironment(Environment environment) {
        this.securityPropertyResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "management.security.");
    }

    public void setStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping = new HashMap<String, HttpStatus>(statusMapping);
    }

    public void addStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping.putAll(statusMapping);
    }

    public void addStatusMapping(Status status, HttpStatus httpStatus) {
        Assert.notNull((Object)status, (String)"Status must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.addStatusMapping(status.getCode(), httpStatus);
    }

    public void addStatusMapping(String statusCode, HttpStatus httpStatus) {
        Assert.notNull((Object)statusCode, (String)"StatusCode must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.statusMapping.put(statusCode, httpStatus);
    }

    @ActuatorGetMapping
    @ResponseBody
    public Object invoke(HttpServletRequest request, Principal principal) {
        if (!((HealthEndpoint)this.getDelegate()).isEnabled()) {
            return this.getDisabledResponse();
        }
        Health health = this.getHealth(request, principal);
        HttpStatus status = this.getStatus(health);
        if (status != null) {
            return new ResponseEntity((Object)health, status);
        }
        return health;
    }

    private HttpStatus getStatus(Health health) {
        String code = health.getStatus().getCode();
        if (code != null) {
            code = code.toLowerCase().replace('_', '-');
            for (String candidate : RelaxedNames.forCamelCase((String)code)) {
                HttpStatus status = this.statusMapping.get(candidate);
                if (status == null) continue;
                return status;
            }
        }
        return null;
    }

    private Health getHealth(HttpServletRequest request, Principal principal) {
        Health currentHealth = this.getCurrentHealth();
        if (this.exposeHealthDetails(request, principal)) {
            return currentHealth;
        }
        return Health.status(currentHealth.getStatus()).build();
    }

    private Health getCurrentHealth() {
        long accessTime = System.currentTimeMillis();
        CachedHealth cached = this.cachedHealth;
        if (cached == null || cached.isStale(accessTime, ((HealthEndpoint)this.getDelegate()).getTimeToLive())) {
            Health health = ((HealthEndpoint)this.getDelegate()).invoke();
            this.cachedHealth = new CachedHealth(health, accessTime);
            return health;
        }
        return cached.getHealth();
    }

    protected boolean exposeHealthDetails(HttpServletRequest request, Principal principal) {
        if (!this.secure) {
            return true;
        }
        List<String> roles = this.getRoles();
        for (String role : roles) {
            if (request.isUserInRole(role)) {
                return true;
            }
            if (!this.isSpringSecurityAuthentication(principal)) continue;
            Authentication authentication = (Authentication)principal;
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                String name = authority.getAuthority();
                if (!role.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getRoles() {
        if (this.roles != null) {
            return this.roles;
        }
        String[] roles = StringUtils.commaDelimitedListToStringArray((String)this.securityPropertyResolver.getProperty("roles", "ROLE_ACTUATOR"));
        roles = StringUtils.trimArrayElements((String[])roles);
        return Arrays.asList(roles);
    }

    private boolean isSpringSecurityAuthentication(Principal principal) {
        return ClassUtils.isPresent((String)"org.springframework.security.core.Authentication", null) && principal instanceof Authentication;
    }

    static class CachedHealth {
        private final Health health;
        private final long creationTime;

        CachedHealth(Health health, long creationTime) {
            this.health = health;
            this.creationTime = creationTime;
        }

        public boolean isStale(long accessTime, long timeToLive) {
            return accessTime - this.creationTime >= timeToLive;
        }

        public Health getHealth() {
            return this.health;
        }
    }
}

