/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.amqp.rabbit.listener.adapter.ReplyFailureException;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.amqp.support.converter.RemoteInvocationResult;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;
import org.springframework.util.TypeUtils;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    protected final MessagingMessageConverterAdapter messagingMessageConverter;
    protected final boolean returnExceptions;
    protected final @Nullable RabbitListenerErrorHandler errorHandler;
    private @Nullable HandlerAdapter handlerAdapter;

    public MessagingMessageListenerAdapter() {
        this(null, null);
    }

    public MessagingMessageListenerAdapter(@Nullable Object bean, @Nullable Method method) {
        this(bean, method, false, null);
    }

    public MessagingMessageListenerAdapter(@Nullable Object bean, @Nullable Method method, boolean returnExceptions, @Nullable RabbitListenerErrorHandler errorHandler) {
        this(bean, method, returnExceptions, errorHandler, false);
    }

    protected MessagingMessageListenerAdapter(@Nullable Object bean, @Nullable Method method, boolean returnExceptions, @Nullable RabbitListenerErrorHandler errorHandler, boolean batch) {
        this.messagingMessageConverter = new MessagingMessageConverterAdapter(bean, method, batch);
        this.returnExceptions = returnExceptions;
        this.errorHandler = errorHandler;
    }

    public void setHandlerAdapter(HandlerAdapter handlerAdapter) {
        this.handlerAdapter = handlerAdapter;
    }

    protected HandlerAdapter getHandlerAdapter() {
        Assert.notNull((Object)this.handlerAdapter, (String)"The 'handlerAdapter' is required");
        return this.handlerAdapter;
    }

    public boolean isAsyncReplies() {
        Assert.notNull((Object)this.handlerAdapter, (String)"The 'handlerAdapter' is required");
        return this.handlerAdapter.isAsyncReplies();
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    @Override
    public void setMessageConverter(@Nullable MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        if (messageConverter != null) {
            this.messagingMessageConverter.setPayloadConverter(messageConverter);
        }
    }

    @Override
    public void onMessage(org.springframework.amqp.core.Message amqpMessage, @Nullable Channel channel) throws Exception {
        Message<?> message = null;
        try {
            message = this.toMessagingMessage(amqpMessage);
            this.invokeHandlerAndProcessResult(amqpMessage, channel, message);
        }
        catch (ListenerExecutionFailedException ex) {
            this.handleException(amqpMessage, channel, message, ex);
        }
        catch (ReplyFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.handleException(amqpMessage, channel, message, new ListenerExecutionFailedException("Failed to convert message", ex, amqpMessage));
        }
    }

    @Override
    protected void asyncFailure(org.springframework.amqp.core.Message request, @Nullable Channel channel, Throwable t, @Nullable Object source) {
        Throwable throwableToHandle = t;
        try {
            this.handleException(request, channel, (Message)source, new ListenerExecutionFailedException("Async Fail", throwableToHandle, request));
            return;
        }
        catch (Exception ex) {
            throwableToHandle = ex;
            super.asyncFailure(request, channel, throwableToHandle, source);
            return;
        }
    }

    protected void handleException(org.springframework.amqp.core.Message amqpMessage, @Nullable Channel channel, @Nullable Message<?> message, ListenerExecutionFailedException e) throws Exception {
        if (this.errorHandler != null) {
            try {
                Object errorResult = this.errorHandler.handleError(amqpMessage, channel, message, e);
                if (errorResult != null) {
                    Object payload = message == null ? null : message.getPayload();
                    InvocationResult invResult = payload == null ? new InvocationResult(errorResult, null, null, null, null) : this.getHandlerAdapter().getInvocationResultFor(errorResult, payload);
                    this.handleResult(invResult, amqpMessage, channel, message);
                } else {
                    this.logger.trace((Object)"Error handler returned no result; acknowledging the message.");
                    if (this.isManualAck()) {
                        this.basicAck(amqpMessage, channel);
                    }
                }
            }
            catch (Exception ex) {
                this.returnOrThrow(amqpMessage, channel, message, ex, ex);
            }
        } else {
            this.returnOrThrow(amqpMessage, channel, message, e.getCause(), (Exception)((Object)e));
        }
    }

    protected void invokeHandlerAndProcessResult(org.springframework.amqp.core.Message amqpMessage, @Nullable Channel channel, Message<?> message) {
        InvocationResult result;
        boolean projectionUsed = amqpMessage.getMessageProperties().isProjectionUsed();
        if (projectionUsed) {
            amqpMessage.getMessageProperties().setProjectionUsed(false);
        }
        if (this.logger.isDebugEnabled() && !projectionUsed) {
            this.logger.debug((Object)("Processing [" + String.valueOf(message) + "]"));
        }
        if (this.messagingMessageConverter.method == null) {
            amqpMessage.getMessageProperties().setTargetMethod(this.getHandlerAdapter().getMethodFor(message.getPayload()));
        }
        if ((result = this.invokeHandler(channel, message, false, amqpMessage)).getReturnValue() != null) {
            this.handleResult(result, amqpMessage, channel, message);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    private void returnOrThrow(org.springframework.amqp.core.Message amqpMessage, @Nullable Channel channel, @Nullable Message<?> message, @Nullable Throwable throwableToReturn, Exception exceptionToThrow) throws Exception {
        if (!this.returnExceptions) {
            throw exceptionToThrow;
        }
        Object payload = message == null ? null : message.getPayload();
        try {
            this.handleResult(new InvocationResult(new RemoteInvocationResult(throwableToReturn), null, (Type)(payload == null ? Object.class : this.getHandlerAdapter().getReturnTypeFor(payload)), this.getHandlerAdapter().getBean(), payload == null ? null : this.getHandlerAdapter().getMethodFor(payload)), amqpMessage, channel, message);
        }
        catch (ReplyFailureException rfe) {
            if (payload == null || Void.TYPE.equals(this.getHandlerAdapter().getReturnTypeFor(payload))) {
                throw exceptionToThrow;
            }
            throw rfe;
        }
    }

    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        return (Message)this.getMessagingMessageConverter().fromMessage(amqpMessage);
    }

    protected InvocationResult invokeHandler(@Nullable Channel channel, Message<?> message, boolean batch, org.springframework.amqp.core.Message ... amqpMessages) {
        try {
            if (batch) {
                return this.getHandlerAdapter().invoke(message, channel);
            }
            org.springframework.amqp.core.Message amqpMessage = amqpMessages[0];
            return this.getHandlerAdapter().invoke(message, amqpMessage, channel, amqpMessage.getMessageProperties());
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage(message.getPayload()), ex, amqpMessages);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.getHandlerAdapter().getMethodAsString(message.getPayload()) + "' threw exception", ex, amqpMessages);
        }
    }

    private String createMessagingErrorMessage(Object payload) {
        return "Listener method could not be invoked with the incoming message\nEndpoint handler details:\nMethod [" + this.getHandlerAdapter().getMethodAsString(payload) + "]\nBean [" + String.valueOf(this.getHandlerAdapter().getBean()) + "]";
    }

    @Override
    protected org.springframework.amqp.core.Message buildMessage(@Nullable Channel channel, @Nullable Object result, @Nullable Type genericType) {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof org.springframework.amqp.core.Message)) {
            if (result instanceof Message) {
                return this.messagingMessageConverter.toMessage(result, new MessageProperties());
            }
            return this.convert(result, genericType, converter);
        }
        if (result instanceof org.springframework.amqp.core.Message) {
            org.springframework.amqp.core.Message msg = (org.springframework.amqp.core.Message)result;
            return msg;
        }
        throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + String.valueOf(result) + "]");
    }

    protected final class MessagingMessageConverterAdapter
    extends MessagingMessageConverter {
        private final @Nullable Object bean;
        final @Nullable Method method;
        private final @Nullable Type inferredArgumentType;
        private final boolean isBatch;
        private boolean isMessageList;
        private boolean isAmqpMessageList;
        private boolean isCollection;

        MessagingMessageConverterAdapter(@Nullable Object bean, Method method, boolean batch) {
            this.bean = bean;
            this.method = method;
            this.isBatch = batch;
            this.inferredArgumentType = this.determineInferredType();
            if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled() && this.inferredArgumentType != null) {
                MessagingMessageListenerAdapter.this.logger.debug((Object)("Inferred argument type for " + String.valueOf(method) + " is " + String.valueOf(this.inferredArgumentType)));
            }
        }

        public boolean isMessageList() {
            return this.isMessageList;
        }

        public boolean isAmqpMessageList() {
            return this.isAmqpMessageList;
        }

        public @Nullable Method getMethod() {
            return this.method;
        }

        protected Object extractPayload(org.springframework.amqp.core.Message message) {
            MessageProperties messageProperties = message.getMessageProperties();
            if (this.bean != null) {
                messageProperties.setTargetBean(this.bean);
            }
            if (this.method != null) {
                messageProperties.setTargetMethod(this.method);
                if (this.inferredArgumentType != null) {
                    messageProperties.setInferredArgumentType(this.inferredArgumentType);
                }
            }
            return MessagingMessageListenerAdapter.this.extractMessage(message);
        }

        private @Nullable Type determineInferredType() {
            if (this.method == null) {
                return null;
            }
            Type genericParameterType = null;
            for (int i = 0; i < this.method.getParameterCount(); ++i) {
                MethodParameter methodParameter = new MethodParameter(this.method, i);
                boolean isHeaderOrHeaders = methodParameter.hasParameterAnnotation(Header.class) || methodParameter.hasParameterAnnotation(Headers.class) || methodParameter.getParameterType().equals(MessageHeaders.class);
                boolean isPayload = methodParameter.hasParameterAnnotation(Payload.class);
                if (isHeaderOrHeaders && isPayload && MessagingMessageListenerAdapter.this.logger.isWarnEnabled()) {
                    MessagingMessageListenerAdapter.this.logger.warn((Object)(this.method.getName() + ": Cannot annotate a parameter with both @Header and @Payload; ignored for payload conversion"));
                }
                if (!this.isEligibleParameter(methodParameter) || isHeaderOrHeaders) continue;
                if (genericParameterType == null) {
                    genericParameterType = this.extractGenericParameterTypFromMethodParameter(methodParameter);
                    if (!this.isBatch || this.isCollection) continue;
                    throw new IllegalStateException("Mis-configuration; a batch listener must consume a List<?> or Collection<?> for method: " + String.valueOf(this.method));
                }
                if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled()) {
                    MessagingMessageListenerAdapter.this.logger.debug((Object)("Ambiguous parameters for target payload for method " + String.valueOf(this.method) + "; no inferred type header added"));
                }
                return null;
            }
            return this.checkOptional(genericParameterType);
        }

        protected @Nullable Type checkOptional(@Nullable Type genericParameterType) {
            ParameterizedType pType;
            if (genericParameterType instanceof ParameterizedType && (pType = (ParameterizedType)genericParameterType).getRawType().equals(Optional.class)) {
                return pType.getActualTypeArguments()[0];
            }
            return genericParameterType;
        }

        private boolean isEligibleParameter(MethodParameter methodParameter) {
            ParameterizedType parameterizedType;
            Type parameterType = methodParameter.getGenericParameterType();
            if (parameterType.equals(Channel.class) || parameterType.equals(MessageProperties.class) || parameterType.equals(org.springframework.amqp.core.Message.class) || parameterType.getTypeName().startsWith("kotlin.coroutines.Continuation")) {
                return false;
            }
            if (parameterType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)parameterType).getRawType().equals(Message.class)) {
                return !(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType);
            }
            return !parameterType.equals(Message.class);
        }

        private Type extractGenericParameterTypFromMethodParameter(MethodParameter methodParameter) {
            Type genericParameterType = methodParameter.getGenericParameterType();
            if (genericParameterType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericParameterType;
                if (parameterizedType.getRawType().equals(Message.class)) {
                    genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                } else if (this.isBatch && (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Collection.class) && parameterizedType.getActualTypeArguments().length == 1)) {
                    ParameterizedType pType;
                    this.isCollection = true;
                    Type paramType = parameterizedType.getActualTypeArguments()[0];
                    boolean messageHasGeneric = paramType instanceof ParameterizedType && (pType = (ParameterizedType)paramType).getRawType().equals(Message.class);
                    this.isMessageList = TypeUtils.isAssignable((Type)paramType, Message.class) || messageHasGeneric;
                    this.isAmqpMessageList = TypeUtils.isAssignable((Type)paramType, org.springframework.amqp.core.Message.class);
                    genericParameterType = messageHasGeneric ? ((ParameterizedType)paramType).getActualTypeArguments()[0] : paramType;
                }
            }
            return genericParameterType;
        }
    }
}

