/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.authentication;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Predicate;
import org.sonar.api.internal.google.common.collect.FluentIterable;
import org.sonar.api.user.UserGroupValidation;

@Immutable
public final class UserIdentity {
    private final String providerLogin;
    private final String login;
    private final String name;
    private final String email;
    private final boolean groupsProvided;
    private final Set<String> groups;

    private UserIdentity(Builder builder) {
        this.providerLogin = builder.providerLogin;
        this.login = builder.login;
        this.name = builder.name;
        this.email = builder.email;
        this.groupsProvided = builder.groupsProvided;
        this.groups = builder.groups;
    }

    public String getProviderLogin() {
        return this.providerLogin;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getEmail() {
        return this.email;
    }

    public boolean shouldSyncGroups() {
        return this.groupsProvided;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static enum ValidateGroupName implements Predicate<String>
    {
        INSTANCE;


        @Override
        public boolean apply(@Nonnull String input) {
            UserGroupValidation.validateGroupName(input);
            return true;
        }
    }

    public static class Builder {
        private String providerLogin;
        private String login;
        private String name;
        private String email;
        private boolean groupsProvided = false;
        private Set<String> groups = new HashSet<String>();

        private Builder() {
        }

        public Builder setProviderLogin(String providerLogin) {
            this.providerLogin = providerLogin;
            return this;
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public Builder setGroups(Set<String> groups) {
            Preconditions.checkNotNull(groups, "Groups cannot be null, please don't use this method if groups should not be synchronized.");
            FluentIterable.from(groups).filter(ValidateGroupName.INSTANCE).toList();
            this.groupsProvided = true;
            this.groups = groups;
            return this;
        }

        public UserIdentity build() {
            Builder.validateProviderLogin(this.providerLogin);
            Builder.validateLogin(this.login);
            Builder.validateName(this.name);
            Builder.validateEmail(this.email);
            return new UserIdentity(this);
        }

        private static void validateProviderLogin(String providerLogin) {
            Preconditions.checkArgument(StringUtils.isNotBlank(providerLogin), "Provider login must not be blank");
            Preconditions.checkArgument(providerLogin.length() <= 255, "Provider login size is incorrect (maximum 255 characters)");
        }

        private static void validateLogin(String login) {
            Preconditions.checkArgument(StringUtils.isNotBlank(login), "User login must not be blank");
            Preconditions.checkArgument(login.length() <= 255 && login.length() >= 3, "User login size is incorrect (Between 3 and 255 characters)");
        }

        private static void validateName(String name) {
            Preconditions.checkArgument(StringUtils.isNotBlank(name), "User name must not be blank");
            Preconditions.checkArgument(name.length() <= 200, "User name size is too big (200 characters max)");
        }

        private static void validateEmail(@Nullable String email) {
            Preconditions.checkArgument(email == null || email.length() <= 100, "User email size is too big (100 characters max)");
        }
    }
}

