/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import java.util.Collection;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleAnnotationUtils;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.check.BelongsToProfile;

@ServerSide
@ComputeEngineSide
public final class AnnotationProfileParser {
    private final RuleFinder ruleFinder;

    public AnnotationProfileParser(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile parse(String repositoryKey, String profileName, String language, Collection<Class> annotatedClasses, ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create(profileName, language);
        for (Class aClass : annotatedClasses) {
            BelongsToProfile belongsToProfile = aClass.getAnnotation(BelongsToProfile.class);
            this.addRule(aClass, belongsToProfile, profile, repositoryKey, messages);
        }
        return profile;
    }

    private void addRule(Class aClass, BelongsToProfile annotation, RulesProfile profile, String repositoryKey, ValidationMessages messages) {
        if (annotation != null && StringUtils.equals(annotation.title(), profile.getName())) {
            String ruleKey = RuleAnnotationUtils.getRuleKey(aClass);
            Rule rule = this.ruleFinder.findByKey(repositoryKey, ruleKey);
            if (rule == null) {
                messages.addWarningText("Rule not found: [repository=" + repositoryKey + ", key=" + ruleKey + "]");
            } else {
                RulePriority priority = null;
                if (annotation.priority() != null) {
                    priority = RulePriority.fromCheckPriority(annotation.priority());
                }
                profile.activateRule(rule, priority);
            }
        }
    }
}

