/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.utils.Version;

@Immutable
public class SonarRuntimeImpl
implements SonarRuntime {
    private final Version version;
    private final SonarProduct product;
    private final SonarQubeSide sonarQubeSide;

    private SonarRuntimeImpl(Version version, SonarProduct product, @Nullable SonarQubeSide sonarQubeSide) {
        Objects.requireNonNull(version);
        Objects.requireNonNull(product);
        Preconditions.checkArgument(product == SonarProduct.SONARQUBE == (sonarQubeSide != null), "sonarQubeSide should be provided only for SonarQube product");
        this.version = version;
        this.product = product;
        this.sonarQubeSide = sonarQubeSide;
    }

    @Override
    public Version getApiVersion() {
        return this.version;
    }

    @Override
    public SonarProduct getProduct() {
        return this.product;
    }

    @Override
    public SonarQubeSide getSonarQubeSide() {
        if (this.sonarQubeSide == null) {
            throw new UnsupportedOperationException("Can only be called in SonarQube");
        }
        return this.sonarQubeSide;
    }

    public static SonarRuntime forSonarQube(Version version, SonarQubeSide side) {
        return new SonarRuntimeImpl(version, SonarProduct.SONARQUBE, side);
    }

    public static SonarRuntime forSonarLint(Version version) {
        return new SonarRuntimeImpl(version, SonarProduct.SONARLINT, null);
    }
}

