/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sonarsource.scanner.api.internal.JarExtractor;
import org.sonarsource.scanner.api.internal.ServerConnection;
import org.sonarsource.scanner.api.internal.cache.FileCache;
import org.sonarsource.scanner.api.internal.cache.FileCacheBuilder;
import org.sonarsource.scanner.api.internal.cache.Logger;

class Jars {
    private final FileCache fileCache;
    private final ServerConnection connection;
    private final JarExtractor jarExtractor;
    private final Logger logger;

    Jars(ServerConnection conn, JarExtractor jarExtractor, Logger logger, Properties props) {
        this.logger = logger;
        this.fileCache = new FileCacheBuilder(logger).setUserHome(props.getProperty("sonar.userHome")).build();
        this.connection = conn;
        this.jarExtractor = jarExtractor;
    }

    Jars(FileCache fileCache, ServerConnection conn, JarExtractor jarExtractor, Logger logger) {
        this.logger = logger;
        this.fileCache = fileCache;
        this.connection = conn;
        this.jarExtractor = jarExtractor;
    }

    FileCache getFileCache() {
        return this.fileCache;
    }

    List<File> download() {
        ArrayList<File> files = new ArrayList<File>();
        this.logger.debug("Extract sonar-scanner-api-batch in temp...");
        files.add(this.jarExtractor.extractToTemp("sonar-scanner-api-batch").toFile());
        files.addAll(this.getScannerEngineFiles());
        return files;
    }

    private List<File> getScannerEngineFiles() {
        ArrayList<File> files = new ArrayList<File>();
        String bootstrapIndex = this.getBootstrapIndex();
        try {
            String[] lines = bootstrapIndex.split("[\r\n]+");
            ScannerFileDownloader scannerFileDownloader = new ScannerFileDownloader(this.connection);
            for (String line : lines) {
                line = line.trim();
                String[] libAndHash = line.split("\\|");
                String filename = libAndHash[0];
                String hash = libAndHash[1];
                files.add(this.fileCache.get(filename, hash, scannerFileDownloader));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to bootstrap from server. Bootstrap index was:\n" + bootstrapIndex, e);
        }
        return files;
    }

    private String getBootstrapIndex() {
        try {
            this.logger.debug("Get bootstrap index...");
            String libs = this.connection.downloadString("/batch/index");
            this.logger.debug("Get bootstrap completed");
            return libs;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get bootstrap index from server", e);
        }
    }

    static class ScannerFileDownloader
    implements FileCache.Downloader {
        private final ServerConnection connection;

        ScannerFileDownloader(ServerConnection conn) {
            this.connection = conn;
        }

        @Override
        public void download(String filename, File toFile) throws IOException {
            this.connection.downloadFile(String.format("/batch/file?name=%s", filename), toFile.toPath());
        }
    }
}

