/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcTypeHelper;
import org.simpleflatmapper.jdbc.impl.setter.ArrayPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BigDecimalPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BigIntegerPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BlobPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BooleanPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BytePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BytesPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.CharacterPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ClobPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ConvertDelegateIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.DatePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.DoublePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.FloatPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.InputStreamPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.IntegerPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.LongPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.NClobPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ObjectPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.OrdinalEnumPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.PreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ReaderPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.RefPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.RowIdPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.SQLXMLPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ShortPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.StringEnumPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.StringPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.TimePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.TimestampPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.URLPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.UUIDBinaryPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.UUIDStringPreparedStatementIndexSetter;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.setter.ContextualIndexedSetter;
import org.simpleflatmapper.map.setter.ContextualIndexedSetterFactory;
import org.simpleflatmapper.util.TypeHelper;

public class PreparedStatementIndexedSetterFactory
implements ContextualIndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey>> {
    public static final PreparedStatementIndexedSetterFactory INSTANCE = new PreparedStatementIndexedSetterFactory();
    private final Map<Class<?>, Factory> factoryPerClass = new HashMap();

    private PreparedStatementIndexedSetterFactory() {
        this.factoryPerClass.put(Boolean.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new BooleanPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Boolean.class, this.factoryPerClass.get(Boolean.TYPE));
        this.factoryPerClass.put(Byte.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new BytePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Byte.class, this.factoryPerClass.get(Byte.TYPE));
        this.factoryPerClass.put(Character.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new CharacterPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Character.class, this.factoryPerClass.get(Character.TYPE));
        this.factoryPerClass.put(Short.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new ShortPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Short.class, this.factoryPerClass.get(Short.TYPE));
        this.factoryPerClass.put(Integer.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new IntegerPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Integer.class, this.factoryPerClass.get(Integer.TYPE));
        this.factoryPerClass.put(Long.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new LongPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Long.class, this.factoryPerClass.get(Long.TYPE));
        this.factoryPerClass.put(Float.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new FloatPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Float.class, this.factoryPerClass.get(Float.TYPE));
        this.factoryPerClass.put(Double.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new DoublePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Double.class, this.factoryPerClass.get(Double.TYPE));
        this.factoryPerClass.put(String.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new StringPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Timestamp.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new TimestampPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Date.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new DatePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Time.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new TimePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(URL.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new URLPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Ref.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new RefPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(BigDecimal.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new BigDecimalPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(BigInteger.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new BigIntegerPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Array.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new ArrayPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(byte[].class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new BytesPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(NClob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new NClobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(RowId.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new RowIdPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Blob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new BlobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Clob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new ClobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(InputStream.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new InputStreamPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Reader.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new ReaderPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(SQLXML.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                return new SQLXMLPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(UUID.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                switch (key.getSqlType(properties)) {
                    case -4: 
                    case -3: 
                    case -2: {
                        return new UUIDBinaryPreparedStatementIndexSetter();
                    }
                    case 1111: {
                        return new ObjectPreparedStatementIndexSetter();
                    }
                }
                return new UUIDStringPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(OffsetTime.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                if (key.getSqlType(properties) == 2013) {
                    return new ObjectPreparedStatementIndexSetter();
                }
                return null;
            }
        });
        this.factoryPerClass.put(OffsetDateTime.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
                if (key.getSqlType(properties) == 2014) {
                    return new ObjectPreparedStatementIndexSetter();
                }
                return null;
            }
        });
    }

    public <T> ContextualIndexedSetter<PreparedStatement, T> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey> arg, ContextFactoryBuilder contextFactoryBuilder, Object ... properties) {
        Type propertyType = arg.getPropertyMeta().getPropertyType();
        Object setter = this.getIndexedSetter(propertyType, arg, contextFactoryBuilder);
        if (setter == null) {
            Class<?> iclass = JdbcTypeHelper.toJavaType(((JdbcColumnKey)arg.getColumnKey()).getSqlType(properties), propertyType);
            setter = this.getSetterWithConvertion(TypeHelper.toClass((Type)propertyType), iclass, contextFactoryBuilder, arg);
        }
        return setter;
    }

    private <P, I> ContextualIndexedSetter<PreparedStatement, P> getSetterWithConvertion(Class<P> pclazz, Class<I> iclass, ContextFactoryBuilder contextFactoryBuilder, PropertyMapping<?, ?, JdbcColumnKey> pm) {
        ContextualIndexedSetter indexedSetter;
        ContextualConverter converter = ConverterService.getInstance().findConverter(pclazz, iclass, contextFactoryBuilder, pm.getColumnDefinition().properties());
        if (converter != null && (indexedSetter = this.getIndexedSetter(iclass, pm, contextFactoryBuilder)) != null) {
            return new ConvertDelegateIndexSetter(indexedSetter, converter);
        }
        return null;
    }

    protected <T> ContextualIndexedSetter<PreparedStatement, T> getIndexedSetter(Type propertyType, PropertyMapping<?, ?, JdbcColumnKey> arg, ContextFactoryBuilder contextFactoryBuilder) {
        Factory setterFactory;
        PreparedStatementIndexSetter<Enum<?>> setter = null;
        if (TypeHelper.isEnum((Type)propertyType)) {
            switch (((JdbcColumnKey)arg.getColumnKey()).getSqlType(arg.getColumnDefinition().properties())) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    setter = new OrdinalEnumPreparedStatementIndexSetter();
                    break;
                }
                default: {
                    setter = new StringEnumPreparedStatementIndexSetter();
                }
            }
        }
        if (setter == null && (setterFactory = this.factoryPerClass.get(TypeHelper.toClass((Type)propertyType))) != null) {
            setter = setterFactory.getIndexedSetter((Object)((JdbcColumnKey)arg.getColumnKey()), contextFactoryBuilder, arg.getColumnDefinition().properties());
        }
        if (setter == null && TypeHelper.isAssignable(SQLData.class, (Type)propertyType)) {
            setter = new ObjectPreparedStatementIndexSetter();
        }
        return setter;
    }

    public static interface Factory
    extends ContextualIndexedSetterFactory<PreparedStatement, JdbcColumnKey> {
    }
}

