/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.simpleflatmapper.converter.AbstractContextualConverterFactory;
import org.simpleflatmapper.converter.AbstractContextualConverterFactoryProducer;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ContextualConverterFactory;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.converter.ToStringConverter;
import org.simpleflatmapper.converter.impl.CharSequenceBigDecimal;
import org.simpleflatmapper.converter.impl.CharSequenceBigInteger;
import org.simpleflatmapper.converter.impl.CharSequenceBooleanConverter;
import org.simpleflatmapper.converter.impl.CharSequenceByteConverter;
import org.simpleflatmapper.converter.impl.CharSequenceCharacterConverter;
import org.simpleflatmapper.converter.impl.CharSequenceDoubleConverter;
import org.simpleflatmapper.converter.impl.CharSequenceFloatConverter;
import org.simpleflatmapper.converter.impl.CharSequenceIntegerConverter;
import org.simpleflatmapper.converter.impl.CharSequenceLongConverter;
import org.simpleflatmapper.converter.impl.CharSequenceShortConverter;
import org.simpleflatmapper.converter.impl.CharSequenceToDateConverter;
import org.simpleflatmapper.converter.impl.CharSequenceToEnumConverter;
import org.simpleflatmapper.converter.impl.CharSequenceUUIDConverter;
import org.simpleflatmapper.converter.impl.MultiFormatCharSequenceToDateConverter;
import org.simpleflatmapper.converter.impl.NumberBigDecimalConverter;
import org.simpleflatmapper.converter.impl.NumberBigIntegerConverter;
import org.simpleflatmapper.converter.impl.NumberByteConverter;
import org.simpleflatmapper.converter.impl.NumberDoubleConverter;
import org.simpleflatmapper.converter.impl.NumberFloatConverter;
import org.simpleflatmapper.converter.impl.NumberIntegerConverter;
import org.simpleflatmapper.converter.impl.NumberLongConverter;
import org.simpleflatmapper.converter.impl.NumberShortConverter;
import org.simpleflatmapper.converter.impl.NumberToEnumConverter;
import org.simpleflatmapper.converter.impl.ObjectToEnumConverter;
import org.simpleflatmapper.converter.impl.ToStringToURLConverter;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.date.DateFormatSupplier;
import org.simpleflatmapper.util.date.DefaultDateFormatSupplier;

public class JavaBaseConverterFactoryProducer
extends AbstractContextualConverterFactoryProducer {
    public void produce(Consumer<? super ContextualConverterFactory<?, ?>> consumer) {
        this.constantConverter(consumer, Number.class, Byte.class, new NumberByteConverter());
        this.constantConverter(consumer, Number.class, Short.class, new NumberShortConverter());
        this.constantConverter(consumer, Number.class, Integer.class, new NumberIntegerConverter());
        this.constantConverter(consumer, Number.class, Long.class, new NumberLongConverter());
        this.constantConverter(consumer, Number.class, Float.class, new NumberFloatConverter());
        this.constantConverter(consumer, Number.class, Double.class, new NumberDoubleConverter());
        this.constantConverter(consumer, Number.class, BigDecimal.class, new NumberBigDecimalConverter());
        this.constantConverter(consumer, Number.class, BigInteger.class, new NumberBigIntegerConverter());
        this.constantConverter(consumer, CharSequence.class, Byte.class, new CharSequenceByteConverter());
        this.constantConverter(consumer, CharSequence.class, BigInteger.class, new CharSequenceBigInteger());
        this.constantConverter(consumer, CharSequence.class, BigDecimal.class, new CharSequenceBigDecimal());
        this.constantConverter(consumer, CharSequence.class, Character.class, new CharSequenceCharacterConverter());
        this.constantConverter(consumer, CharSequence.class, Short.class, new CharSequenceShortConverter());
        this.constantConverter(consumer, CharSequence.class, Integer.class, new CharSequenceIntegerConverter());
        this.constantConverter(consumer, CharSequence.class, Long.class, new CharSequenceLongConverter());
        this.constantConverter(consumer, CharSequence.class, Float.class, new CharSequenceFloatConverter());
        this.constantConverter(consumer, CharSequence.class, Double.class, new CharSequenceDoubleConverter());
        this.constantConverter(consumer, CharSequence.class, UUID.class, new CharSequenceUUIDConverter());
        this.constantConverter(consumer, CharSequence.class, Boolean.class, new CharSequenceBooleanConverter());
        this.factoryConverter(consumer, new DateConverterFactory());
        this.factoryConverter(consumer, new EnumConverterFactory());
        this.factoryConverter(consumer, new NumberEnumConverterFactory());
        this.factoryConverter(consumer, new ObjectEnumConverterFactory());
        this.factoryConverter(consumer, new ArrayToListConverterFactory());
        this.constantConverter(consumer, Object.class, String.class, ToStringConverter.INSTANCE);
        this.constantConverter(consumer, Object.class, URL.class, new ToStringToURLConverter());
    }

    private static class ArrayToListConverterFactory
    extends AbstractContextualConverterFactory<Object, List> {
        protected ArrayToListConverterFactory() {
            super(Object.class, List.class);
        }

        @Override
        public ContextualConverter<? super Object, ? extends List> newConverter(ConvertingTypes targetedTypes, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
            return new ContextualConverter<Object, List>(){

                @Override
                public List convert(Object in, Context context) throws Exception {
                    if (in == null) {
                        return null;
                    }
                    int length = Array.getLength(in);
                    ArrayList<Object> arrayList = new ArrayList<Object>(length);
                    for (int i = 0; i < length; ++i) {
                        arrayList.add(Array.get(in, i));
                    }
                    return arrayList;
                }
            };
        }

        @Override
        public ConvertingScore score(ConvertingTypes targetedTypes) {
            if (TypeHelper.isArray((Type)targetedTypes.getFrom())) {
                return new ConvertingScore(256, ConvertingTypes.getSourceScore(this.convertingTypes.getTo(), targetedTypes.getTo()));
            }
            return ConvertingScore.NO_MATCH;
        }
    }

    private static class ObjectEnumConverterFactory
    extends AbstractContextualConverterFactory<Object, Enum> {
        public ObjectEnumConverterFactory() {
            super(Object.class, Enum.class);
        }

        @Override
        public ContextualConverter<? super Object, ? extends Enum> newConverter(ConvertingTypes targetedTypes, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
            return new ObjectToEnumConverter(TypeHelper.toClass((Type)targetedTypes.getTo()));
        }

        @Override
        public ConvertingScore score(ConvertingTypes targetedTypes) {
            if (TypeHelper.isAssignable(Enum.class, (Type)targetedTypes.getTo())) {
                return new ConvertingScore(ConvertingTypes.getSourceScore(this.convertingTypes.getFrom(), targetedTypes.getFrom()), 256);
            }
            return ConvertingScore.NO_MATCH;
        }
    }

    private static class NumberEnumConverterFactory
    extends AbstractContextualConverterFactory<Number, Enum> {
        public NumberEnumConverterFactory() {
            super(Number.class, Enum.class);
        }

        @Override
        public ContextualConverter<? super Number, ? extends Enum> newConverter(ConvertingTypes targetedTypes, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
            return new NumberToEnumConverter(TypeHelper.toClass((Type)targetedTypes.getTo()));
        }

        @Override
        public ConvertingScore score(ConvertingTypes targetedTypes) {
            if (TypeHelper.isAssignable(Enum.class, (Type)targetedTypes.getTo())) {
                return new ConvertingScore(ConvertingTypes.getSourceScore(this.convertingTypes.getFrom(), targetedTypes.getFrom()), 256);
            }
            return ConvertingScore.NO_MATCH;
        }
    }

    private static class EnumConverterFactory
    extends AbstractContextualConverterFactory<CharSequence, Enum> {
        public EnumConverterFactory() {
            super(CharSequence.class, Enum.class);
        }

        @Override
        public ContextualConverter<? super CharSequence, ? extends Enum> newConverter(ConvertingTypes targetedTypes, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
            return new CharSequenceToEnumConverter(TypeHelper.toClass((Type)targetedTypes.getTo()));
        }

        @Override
        public ConvertingScore score(ConvertingTypes targetedTypes) {
            if (TypeHelper.isAssignable(Enum.class, (Type)targetedTypes.getTo())) {
                return new ConvertingScore(ConvertingTypes.getSourceScore(this.convertingTypes.getFrom(), targetedTypes.getFrom()), 256);
            }
            return ConvertingScore.NO_MATCH;
        }
    }

    private static class DateConverterFactory
    extends AbstractContextualConverterFactory<CharSequence, Date> {
        public DateConverterFactory() {
            super(CharSequence.class, Date.class);
        }

        @Override
        public ContextualConverter<? super CharSequence, ? extends Date> newConverter(ConvertingTypes targetedTypes, ContextFactoryBuilder contextFactoryBuilder, Object ... params) {
            List<String> formats = this.getFormat(params);
            TimeZone timeZone = this.getTimeZone(params);
            if (formats.isEmpty()) {
                return null;
            }
            if (formats.size() == 1) {
                final SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formats.get(0));
                simpleDateFormat.setTimeZone(timeZone);
                int contextIndex = contextFactoryBuilder.addSupplier(new Supplier<SimpleDateFormat>(){

                    public SimpleDateFormat get() {
                        return (SimpleDateFormat)simpleDateFormat.clone();
                    }
                });
                return new CharSequenceToDateConverter(contextIndex);
            }
            final SimpleDateFormat[] simpleDateFormats = new SimpleDateFormat[formats.size()];
            for (int i = 0; i < simpleDateFormats.length; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formats.get(simpleDateFormats.length - i - 1));
                simpleDateFormat.setTimeZone(timeZone);
                simpleDateFormats[i] = simpleDateFormat;
            }
            int contextIndex = contextFactoryBuilder.addSupplier(new Supplier<SimpleDateFormat[]>(){

                public SimpleDateFormat[] get() {
                    SimpleDateFormat[] simpleDateFormatsCopy = new SimpleDateFormat[simpleDateFormats.length];
                    for (int i = 0; i < simpleDateFormats.length; ++i) {
                        simpleDateFormatsCopy[i] = (SimpleDateFormat)simpleDateFormats[i].clone();
                    }
                    return simpleDateFormatsCopy;
                }
            });
            return new MultiFormatCharSequenceToDateConverter(contextIndex);
        }

        private TimeZone getTimeZone(Object[] params) {
            TimeZone defaultValue = TimeZone.getDefault();
            if (params != null) {
                for (Object o : params) {
                    Supplier s;
                    Object o1;
                    if (!(o instanceof Supplier) || !((o1 = (s = (Supplier)o).get()) instanceof TimeZone)) continue;
                    return (TimeZone)o1;
                }
            }
            return defaultValue;
        }

        private List<String> getFormat(Object[] params) {
            String defaultValue = null;
            ArrayList<String> formats = new ArrayList<String>();
            if (params != null) {
                for (Object o : params) {
                    if (o instanceof DefaultDateFormatSupplier) {
                        defaultValue = ((DefaultDateFormatSupplier)o).get();
                        continue;
                    }
                    if (!(o instanceof DateFormatSupplier)) continue;
                    formats.add(((DateFormatSupplier)o).get());
                }
            }
            if (formats.isEmpty() && defaultValue != null) {
                formats.add(defaultValue);
            }
            return formats;
        }
    }
}

