/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jpa;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jpa.WikittyJPAUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class WikittyStorageJPA
implements WikittyStorage {
    private static Log log = LogFactory.getLog(WikittyStorageJPA.class);
    @Autowired
    protected WikittyExtensionStorage extensionStorage;
    @PersistenceUnit
    protected EntityManagerFactory entityManagerFactory;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) throws WikittyException {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        UpdateResponse result = new UpdateResponse();
        for (Wikitty wikitty : wikitties) {
            String wikittyId = wikitty.getId();
            String actualVersion = null;
            String requestedVersion = wikitty.getVersion();
            Wikitty wikittyFound = (Wikitty)entityManager.find(Wikitty.class, (Object)wikittyId);
            if (wikittyFound != null) {
                actualVersion = wikittyFound.getVersion();
            }
            String newVersion = null;
            if (disableAutoVersionIncrement) {
                if (actualVersion == null) {
                    newVersion = requestedVersion == null ? "0.0" : requestedVersion;
                } else if (requestedVersion == null) {
                    newVersion = WikittyUtil.incrementMajorRevision((String)actualVersion);
                } else {
                    if (WikittyUtil.versionEquals((String)actualVersion, (String)requestedVersion)) continue;
                    if (!WikittyUtil.versionGreaterThan((String)requestedVersion, (String)actualVersion)) throw new WikittyException(String.format("Your wikitty '%s' is obsolete (saving: '%s'; existing: '%s')", wikittyId, requestedVersion, actualVersion));
                    newVersion = requestedVersion;
                }
            } else {
                if (WikittyUtil.versionEquals((String)actualVersion, (String)requestedVersion)) continue;
                if (WikittyUtil.versionGreaterThan((String)actualVersion, (String)requestedVersion)) {
                    throw new WikittyException(String.format("Your wikitty '%s' is obsolete", wikittyId));
                }
                newVersion = WikittyUtil.incrementMajorRevision((String)actualVersion);
            }
            for (WikittyExtension ext : wikitty.getExtensions()) {
                String extName = ext.getName();
                for (String fieldName : ext.getFieldNames()) {
                    FieldType fieldType = ext.getFieldType(fieldName);
                    Object value = wikitty.getFieldAsObject(extName, fieldName);
                    if (!fieldType.isNotNull() || value != null) continue;
                    throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, extName));
                }
            }
            wikitty.setVersion(newVersion);
            wikitty.clearDirty();
            if (actualVersion == null) {
                entityManager.persist((Object)wikitty);
            } else {
                entityManager.merge((Object)wikitty);
            }
            result.addVersionUpdate(wikitty.getId(), newVersion);
        }
        return result;
    }

    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        try {
            EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
            UpdateResponse result = new UpdateResponse();
            Date now = new Date();
            for (String id : ids) {
                if (!this.exists(transaction, id)) {
                    throw new WikittyException(String.format("Wikitty with id '%s' don't exists", id));
                }
                Wikitty wikitty = (Wikitty)entityManager.find(Wikitty.class, (Object)id);
                wikitty.setDeleteDate(now);
                entityManager.persist((Object)wikitty);
                result.addDeletionDateUpdate(id, now);
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        Wikitty wikitty = (Wikitty)entityManager.find(Wikitty.class, (Object)id);
        boolean result = wikitty != null;
        return result;
    }

    public boolean isDeleted(WikittyTransaction transaction, String id) {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        Wikitty wikitty = (Wikitty)entityManager.find(Wikitty.class, (Object)id);
        Date deleteDate = wikitty.getDeleteDate();
        boolean result = deleteDate != null;
        return result;
    }

    public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldNames) {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        Wikitty wikitty = (Wikitty)entityManager.find(Wikitty.class, (Object)id);
        if (wikitty == null) {
            throw new WikittyException(String.format("The wikitty not exsist with id '%s'", id));
        }
        return wikitty;
    }

    public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        Query query = entityManager.createQuery("SELECT we FROM Wikitty we");
        List results = query.getResultList();
        for (Wikitty wikitty : results) {
            scanner.scan(wikitty);
        }
    }

    public void clear(WikittyTransaction transaction) {
    }
}

