/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jdbc.WikittyJDBCUtil;

public class WikittyStorageJDBC
implements WikittyStorage {
    protected static Log log = LogFactory.getLog(WikittyStorageJDBC.class);
    protected final Properties conf;
    private static final Pattern listFieldPattern = Pattern.compile("(.*)\\[(\\d+)/(\\d+)\\]");
    protected WikittyExtensionStorage extensionStorage;

    public WikittyStorageJDBC(WikittyExtensionStorage extensionStorage) {
        this(extensionStorage, null);
    }

    public WikittyStorageJDBC(WikittyExtensionStorage extensionStorage, Properties properties) {
        this.conf = WikittyJDBCUtil.loadProperties(properties);
        this.extensionStorage = extensionStorage;
        try {
            Class.forName(this.conf.getProperty("jdbc.con.driver"));
        }
        catch (ClassNotFoundException eee) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Couldn't find the driver!");
                eee.printStackTrace();
            }
            throw new WikittyException((Exception)eee);
        }
        Connection connection = WikittyJDBCUtil.getJDBCConnection(this.conf);
        try {
            Statement statement = connection.createStatement();
            statement.execute(this.conf.getProperty("jdbc.queries.creation.wikitty.admin"));
            statement.execute(this.conf.getProperty("jdbc.queries.creation.wikitty.data"));
            WikittyJDBCUtil.commitJDBCConnection(connection);
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.rollbackJDBCConnection(connection);
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    protected String getColName(FieldType.TYPE type) {
        String result;
        switch (type) {
            case BOOLEAN: {
                result = "booleanValue";
                break;
            }
            case DATE: {
                result = "dateValue";
                break;
            }
            case NUMERIC: {
                result = "numberValue";
                break;
            }
            default: {
                result = "textValue";
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) throws WikittyException {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            UpdateResponse result = new UpdateResponse();
            for (Wikitty wikitty : wikitties) {
                String q;
                String query = String.format(this.conf.getProperty("jdbc.queries.select.where"), "version", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setString(1, wikitty.getId());
                ResultSet versionResultSet = statement.executeQuery();
                String extensionList = "";
                boolean wikittyAlreadyExists = versionResultSet.first();
                String actualVersion = null;
                String requestedVersion = wikitty.getVersion();
                if (wikittyAlreadyExists) {
                    actualVersion = versionResultSet.getString("version");
                }
                String newVersion = null;
                if (disableAutoVersionIncrement) {
                    if (actualVersion == null) {
                        newVersion = requestedVersion == null ? "0.0" : requestedVersion;
                    } else if (requestedVersion == null) {
                        newVersion = WikittyUtil.incrementMajorRevision((String)actualVersion);
                    } else {
                        if (WikittyUtil.versionEquals((String)actualVersion, (String)requestedVersion)) continue;
                        if (!WikittyUtil.versionGreaterThan((String)requestedVersion, (String)actualVersion)) throw new WikittyException(String.format("Your wikitty '%s' is obsolete (saving: '%s'; existing: '%s')", wikitty.getId(), requestedVersion, actualVersion));
                        newVersion = requestedVersion;
                    }
                } else {
                    if (WikittyUtil.versionEquals((String)actualVersion, (String)requestedVersion)) continue;
                    if (WikittyUtil.versionGreaterThan((String)actualVersion, (String)requestedVersion)) {
                        throw new WikittyException(String.format("Your wikitty '%s' is obsolete", wikitty.getId()));
                    }
                    newVersion = WikittyUtil.incrementMajorRevision((String)actualVersion);
                }
                if (!wikittyAlreadyExists) {
                    q = this.conf.getProperty("jdbc.queries.insert.wikitty.admin");
                    WikittyJDBCUtil.doQuery(connection, q, wikitty.getId(), newVersion, "");
                }
                result.addVersionUpdate(wikitty.getId(), newVersion);
                WikittyJDBCUtil.doQuery(connection, this.conf.getProperty("jdbc.queries.delete.wikitty.data"), wikitty.getId());
                for (WikittyExtension ext : wikitty.getExtensions()) {
                    extensionList = extensionList + "," + ext.getId();
                    for (String fieldName : ext.getFieldNames()) {
                        FieldType type = ext.getFieldType(fieldName);
                        if (type.isCollection()) {
                            List list = wikitty.getFieldAsList(ext.getName(), fieldName, Object.class);
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    Object value = list.get(i);
                                    String colName = this.getColName(type.getType());
                                    String q2 = String.format(this.conf.getProperty("jdbc.queries.insert.wikitty.data"), colName);
                                    WikittyJDBCUtil.doQuery(connection, q2, wikitty.getId(), ext.getName() + "." + fieldName + "[" + i + "/" + list.size() + "]", value);
                                }
                                continue;
                            }
                            if (!type.isNotNull()) continue;
                            throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                        }
                        Object value = wikitty.getFieldAsObject(ext.getName(), fieldName);
                        if (value != null) {
                            String colName = this.getColName(type.getType());
                            String q3 = String.format(this.conf.getProperty("jdbc.queries.insert.wikitty.data"), colName);
                            WikittyJDBCUtil.doQuery(connection, q3, wikitty.getId(), ext.getName() + "." + fieldName, value);
                            continue;
                        }
                        if (!type.isNotNull()) continue;
                        throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                    }
                }
                if (extensionList.length() > 0) {
                    String[] splits;
                    extensionList = extensionList.substring(1);
                    String extensionList2 = "";
                    for (String split : splits = extensionList.split(",")) {
                        String extName = WikittyExtension.computeName((String)split);
                        String lastVersion = this.extensionStorage.getLastVersion(transaction, extName);
                        extensionList2 = extensionList2 + "," + WikittyExtension.computeId((String)extName, (String)lastVersion);
                    }
                    extensionList = extensionList2.substring(1);
                }
                q = this.conf.getProperty("jdbc.queries.update.wikitty.admin");
                WikittyJDBCUtil.doQuery(connection, q, newVersion, extensionList, wikitty.getId());
                wikitty.setVersion(newVersion);
                wikitty.clearDirty();
            }
            UpdateResponse updateResponse = result;
            return updateResponse;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            boolean result;
            String q = String.format(this.conf.getProperty("jdbc.queries.select.where"), "id", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, id);
            ResultSet resultSet = statement.executeQuery();
            boolean bl = result = resultSet.first();
            return bl;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public boolean isDeleted(WikittyTransaction transaction, String id) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            String q = String.format(this.conf.getProperty("jdbc.queries.select.where"), "deletionDate", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, id);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.first()) {
                boolean result;
                boolean bl = result = resultSet.getDate("deletionDate") != null;
                return bl;
            }
            try {
                throw new WikittyException(String.format("Wikitty with id '%s' doesn't exists", id));
            }
            catch (SQLException eee) {
                throw new WikittyException((Exception)eee);
            }
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldName) throws WikittyException {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            String q = String.format(this.conf.getProperty("jdbc.queries.select.where.notdeleted"), "*", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN, "id");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, id);
            ResultSet adminResultSet = statement.executeQuery();
            if (adminResultSet.first()) {
                Wikitty result;
                String version = adminResultSet.getString("version");
                String extensionList = adminResultSet.getString("extension_list");
                String qdata = String.format(this.conf.getProperty("jdbc.queries.select.where"), "*", WikittyJDBCUtil.TABLE_WIKITTY_DATA, "id");
                PreparedStatement sta = connection.prepareStatement(qdata);
                sta.setString(1, id);
                ResultSet dataResultSet = sta.executeQuery();
                Wikitty wikitty = result = this.constructWikitty(transaction, id, version, extensionList, dataResultSet, fqFieldName);
                return wikitty;
            }
            try {
                throw new WikittyException(String.format("Can't restore wikitty '%s'", id));
            }
            catch (SQLException eee) {
                throw new WikittyException(String.format("Can't restore wikitty '%s'", id), (Exception)eee);
            }
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            UpdateResponse result = new UpdateResponse();
            Date now = new Date();
            for (String id : ids) {
                if (!this.exists(transaction, id)) {
                    throw new WikittyException(String.format("Wikitty with id '%s' doesn't exists", id));
                }
                if (this.isDeleted(transaction, id)) {
                    throw new WikittyException(String.format("Wikitty with id '%s' is already deleted", id));
                }
                WikittyJDBCUtil.doQuery(connection, this.conf.getProperty("jdbc.queries.delete.wikitty.admin"), id);
                result.addDeletionDateUpdate(id, now);
            }
            UpdateResponse updateResponse = result;
            return updateResponse;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty("jdbc.queries.select.notdeleted"), "id", WikittyJDBCUtil.TABLE_WIKITTY_ADMIN));
            resultSet.beforeFirst();
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                Wikitty wikitty = this.restore(transaction, id, new String[0]);
                scanner.scan(wikitty);
            }
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    protected Wikitty constructWikitty(WikittyTransaction transaction, String id, String version, String extensionList, ResultSet resultSet, String ... fqFieldName) throws SQLException {
        HashSet<String> acceptedField = new HashSet<String>(Arrays.asList(fqFieldName));
        Wikitty result = new Wikitty(id);
        result.setVersion(version);
        if (extensionList != null && !"".equals(extensionList)) {
            for (String ext : extensionList.split(",")) {
                String extName = WikittyExtension.computeName((String)ext);
                String extVersion = WikittyExtension.computeVersion((String)ext);
                WikittyExtension extension = this.extensionStorage.restore(transaction, extName, extVersion);
                result.addExtension(extension);
            }
        }
        HashMap<String, Object[]> listFieldMap = new HashMap<String, Object[]>();
        resultSet.beforeFirst();
        while (resultSet.next()) {
            String fqfieldName = resultSet.getString("fieldName");
            if (!this.isAcceptedField(acceptedField, fqfieldName)) continue;
            FieldType type = result.getFieldType(fqfieldName);
            Object value = null;
            switch (type.getType()) {
                case BOOLEAN: {
                    value = resultSet.getBoolean("booleanValue");
                    break;
                }
                case DATE: {
                    Timestamp timestamp = resultSet.getTimestamp("dateValue");
                    if (timestamp == null) break;
                    value = new Date(timestamp.getTime());
                    break;
                }
                case NUMERIC: {
                    value = resultSet.getBigDecimal("numberValue");
                    break;
                }
                case STRING: {
                    value = resultSet.getString("textValue");
                    break;
                }
                case WIKITTY: {
                    value = resultSet.getString("textValue");
                    break;
                }
                default: {
                    value = resultSet.getString("textValue");
                }
            }
            if (type.isCollection()) {
                Matcher match = listFieldPattern.matcher(fqfieldName);
                if (match.find()) {
                    fqfieldName = match.group(1);
                    int index = Integer.parseInt(match.group(2));
                    Object[] array = (Object[])listFieldMap.get(fqfieldName);
                    if (array == null) {
                        int size = Integer.parseInt(match.group(3));
                        array = new Object[size];
                        listFieldMap.put(fqfieldName, array);
                    }
                    array[index] = value;
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error((Object)String.format("Can't read list field correctly '%s'", fqfieldName));
                continue;
            }
            result.setFqField(fqfieldName, value);
        }
        for (String fieldName : listFieldMap.keySet()) {
            Object[] array = (Object[])listFieldMap.get(fieldName);
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array));
            result.setFqField(fieldName, list);
        }
        return result;
    }

    protected boolean isAcceptedField(Set<String> acceptedField, String fqfieldName) {
        boolean result = acceptedField.isEmpty();
        if (!result) {
            int crochet = fqfieldName.indexOf("[");
            if (crochet != -1) {
                fqfieldName = fqfieldName.substring(0, crochet);
            }
            result = acceptedField.contains(fqfieldName);
        }
        return result;
    }

    public void clear(WikittyTransaction transaction) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            WikittyJDBCUtil.doQuery(connection, this.conf.getProperty("jdbc.queries.clear.wikitty"), new Object[0]);
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }
}

