/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.cli;

import java.io.File;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteControlConfiguration;

public class RemoteControlLauncher {
    public static void usage(String msg) {
        if (msg != null) {
            System.err.println(msg + ":");
        }
        String INDENT = "  ";
        String INDENT2X = INDENT + INDENT;
        RemoteControlLauncher.printWrappedErrorLine("", "Usage: java -jar selenium-server.jar [-interactive] [options]\n");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-port <nnnn>: the port number the selenium server should use (default 4444)");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-timeout <nnnn>: an integer number of seconds we should allow a client to be idle");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-browserTimeout <nnnn>: an integer number of seconds a browser is allowed to hang");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-interactive: puts you into interactive mode.  See the tutorial for more details");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-singleWindow: puts you into a mode where the test web site executes in a frame. This mode should only be selected if the application under test does not use frames.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-profilesLocation: Specifies the directory that holds the profiles that java clients can use to start up selenium.  Currently supported for Firefox only.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-forcedBrowserMode <browser>: sets the browser mode to a single argument (e.g. \"*iexplore\") for all sessions, no matter what is passed to getNewBrowserSession");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-forcedBrowserModeRestOfLine <browser>: sets the browser mode to all the remaining tokens on the line (e.g. \"*custom /some/random/place/iexplore.exe\") for all sessions, no matter what is passed to getNewBrowserSession");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-userExtensions <file>: indicates a JavaScript file that will be loaded into selenium");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-browserSessionReuse: stops re-initialization and spawning of the browser between tests");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-avoidProxy: By default, we proxy every browser request; set this flag to make the browser use our proxy only for URLs containing '/selenium-server'");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-firefoxProfileTemplate <dir>: normally, we generate a fresh empty Firefox profile every time we launch.  You can specify a directory to make us copy your profile directory instead.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-debug: puts you into debug mode, with more trace information and diagnostics on the console");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-browserSideLog: enables logging on the browser side; logging messages will be transmitted to the server.  This can affect performance.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-ensureCleanSession: If the browser does not have user profiles, make sure every new session has no artifacts from previous sessions.  For example, enabling this option will cause all user cookies to be archived before launching IE, and restored after IE is closed.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-trustAllSSLCertificates: Forces the Selenium proxy to trust all SSL certificates.  This doesn't work in browsers that don't use the Selenium proxy.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-log <logFileName>: writes lots of debug information out to a log file");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-htmlSuite <browser> <startURL> <suiteFile> <resultFile>: Run a single HTML Selenese (Selenium Core) suite and then exit immediately, using the specified browser (e.g. \"*firefox\") on the specified URL (e.g. \"http://www.google.com\").  You need to specify the absolute path to the HTML test suite as well as the path to the HTML results file we'll generate.");
        RemoteControlLauncher.printWrappedErrorLine(INDENT, "-proxyInjectionMode: puts you into proxy injection mode, a mode where the selenium server acts as a proxy server for all content going to the test application.  Under this mode, multiple domains can be visited, and the following additional flags are supported:\n");
        RemoteControlLauncher.printWrappedErrorLine(INDENT2X, "-dontInjectRegex <regex>: an optional regular expression that proxy injection mode can use to know when to bypss injection");
        RemoteControlLauncher.printWrappedErrorLine(INDENT2X, "-userJsInjection <file>: specifies a JavaScript file which will then be injected into all pages");
        RemoteControlLauncher.printWrappedErrorLine(INDENT2X, "-userContentTransformation <regex> <replacement>: a regular expression which is matched against all test HTML content; the second is a string which will replace matches.  These flags can be used any number of times.  A simple example of how this could be useful: if you add \"-userContentTransformation https http\" then all \"https\" strings in the HTML of the test application will be changed to be \"http\".");
    }

    public static RemoteControlConfiguration parseLauncherOptions(String[] args) {
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setPort(RemoteControlConfiguration.getDefaultPort());
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-h".equalsIgnoreCase(arg) || "-help".equalsIgnoreCase(arg)) {
                RemoteControlLauncher.usage(null);
                System.exit(1);
                continue;
            }
            if ("-defaultBrowserString".equalsIgnoreCase(arg)) {
                RemoteControlLauncher.usage("-defaultBrowserString has been renamed -forcedBrowserMode");
                continue;
            }
            if ("-forcedBrowserMode".equalsIgnoreCase(arg)) {
                configuration.setForcedBrowserMode(RemoteControlLauncher.getArg(args, ++i));
                if (i >= args.length) continue;
                System.err.println("Warning: -forcedBrowserMode no longer consumes all remaining arguments on line (use -forcedBrowserModeRestOfLine for that)");
                continue;
            }
            if ("-forcedBrowserModeRestOfLine".equalsIgnoreCase(arg)) {
                ++i;
                while (i < args.length) {
                    if (null == configuration.getForcedBrowserMode()) {
                        configuration.setForcedBrowserMode("");
                    } else {
                        configuration.setForcedBrowserMode(configuration.getForcedBrowserMode() + " ");
                    }
                    configuration.setForcedBrowserMode(configuration.getForcedBrowserMode() + args[i]);
                    ++i;
                }
                continue;
            }
            if ("-log".equalsIgnoreCase(arg)) {
                configuration.setLogOutFileName(RemoteControlLauncher.getArg(args, ++i));
                continue;
            }
            if ("-captureLogsOnQuit".equalsIgnoreCase(arg)) {
                configuration.setCaptureLogsOnQuit(true);
                continue;
            }
            if ("-port".equalsIgnoreCase(arg)) {
                configuration.setPort(Integer.parseInt(RemoteControlLauncher.getArg(args, ++i)));
                continue;
            }
            if ("-multiWindow".equalsIgnoreCase(arg)) {
                configuration.setSingleWindow(false);
                continue;
            }
            if ("-singleWindow".equalsIgnoreCase(arg)) {
                configuration.setSingleWindow(true);
                continue;
            }
            if ("-profilesLocation".equalsIgnoreCase(arg)) {
                File profilesLocation;
                if (!(profilesLocation = new File(RemoteControlLauncher.getArg(args, ++i))).exists()) {
                    System.err.println("Specified profile location directory does not exist: " + profilesLocation);
                    System.exit(1);
                }
                configuration.setProfilesLocation(profilesLocation);
                continue;
            }
            if ("-avoidProxy".equalsIgnoreCase(arg)) {
                configuration.setAvoidProxy(true);
                continue;
            }
            if ("-proxyInjectionMode".equalsIgnoreCase(arg)) {
                configuration.setProxyInjectionModeArg(true);
                configuration.setSingleWindow(true);
                continue;
            }
            if ("-portDriversShouldContact".equalsIgnoreCase(arg)) {
                configuration.setPortDriversShouldContact(Integer.parseInt(RemoteControlLauncher.getArg(args, ++i)));
                continue;
            }
            if ("-noBrowserSessionReuse".equalsIgnoreCase(arg)) {
                configuration.setReuseBrowserSessions(false);
                continue;
            }
            if ("-browserSessionReuse".equalsIgnoreCase(arg)) {
                configuration.setReuseBrowserSessions(true);
                continue;
            }
            if ("-firefoxProfileTemplate".equalsIgnoreCase(arg)) {
                configuration.setFirefoxProfileTemplate(new File(RemoteControlLauncher.getArg(args, ++i)));
                if (configuration.getFirefoxProfileTemplate().exists()) continue;
                System.err.println("Firefox profile template doesn't exist: " + configuration.getFirefoxProfileTemplate().getAbsolutePath());
                System.exit(1);
                continue;
            }
            if ("-ensureCleanSession".equalsIgnoreCase(arg)) {
                configuration.setEnsureCleanSession(true);
                continue;
            }
            if ("-dontInjectRegex".equalsIgnoreCase(arg)) {
                configuration.setDontInjectRegex(RemoteControlLauncher.getArg(args, ++i));
                continue;
            }
            if ("-browserSideLog".equalsIgnoreCase(arg)) {
                configuration.setBrowserSideLogEnabled(true);
                continue;
            }
            if ("-debug".equalsIgnoreCase(arg)) {
                configuration.setDebugMode(true);
                continue;
            }
            if ("-debugURL".equalsIgnoreCase(arg)) {
                configuration.setDebugURL(RemoteControlLauncher.getArg(args, ++i));
                continue;
            }
            if ("-timeout".equalsIgnoreCase(arg)) {
                configuration.setTimeoutInSeconds(Integer.parseInt(RemoteControlLauncher.getArg(args, ++i)));
                continue;
            }
            if ("-jettyThreads".equalsIgnoreCase(arg)) {
                int jettyThreadsCount = Integer.parseInt(RemoteControlLauncher.getArg(args, ++i));
                configuration.setJettyThreads(jettyThreadsCount);
                continue;
            }
            if ("-trustAllSSLCertificates".equalsIgnoreCase(arg)) {
                configuration.setTrustAllSSLCertificates(true);
                continue;
            }
            if ("-userJsInjection".equalsIgnoreCase(arg)) {
                configuration.setUserJSInjection(true);
                if (InjectionHelper.addUserJsInjectionFile(RemoteControlLauncher.getArg(args, ++i))) continue;
                RemoteControlLauncher.usage(null);
                System.exit(1);
                continue;
            }
            if ("-userContentTransformation".equalsIgnoreCase(arg)) {
                if (InjectionHelper.addUserContentTransformation(RemoteControlLauncher.getArg(args, ++i), RemoteControlLauncher.getArg(args, ++i))) continue;
                RemoteControlLauncher.usage(null);
                System.exit(1);
                continue;
            }
            if ("-userExtensions".equalsIgnoreCase(arg)) {
                configuration.setUserExtensions(new File(RemoteControlLauncher.getArg(args, ++i)));
                if (!configuration.getUserExtensions().exists()) {
                    System.err.println("User Extensions file doesn't exist: " + configuration.getUserExtensions().getAbsolutePath());
                    System.exit(1);
                }
                if ("user-extensions.js".equalsIgnoreCase(configuration.getUserExtensions().getName())) continue;
                System.err.println("User extensions file MUST be called \"user-extensions.js\": " + configuration.getUserExtensions().getAbsolutePath());
                System.exit(1);
                continue;
            }
            if ("-selfTest".equalsIgnoreCase(arg)) {
                configuration.setSelfTest(true);
                configuration.setSelfTestDir(new File(RemoteControlLauncher.getArg(args, ++i)));
                configuration.getSelfTestDir().mkdirs();
                continue;
            }
            if ("-htmlSuite".equalsIgnoreCase(arg)) {
                try {
                    System.setProperty("htmlSuite.browserString", args[++i]);
                    System.setProperty("htmlSuite.startURL", args[++i]);
                    System.setProperty("htmlSuite.suiteFilePath", args[++i]);
                    System.setProperty("htmlSuite.resultFilePath", args[++i]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Not enough command line arguments for -htmlSuite");
                    System.err.println("-htmlSuite requires you to specify:");
                    System.err.println("* browserString (e.g. \"*firefox\")");
                    System.err.println("* startURL (e.g. \"http://www.google.com\")");
                    System.err.println("* suiteFile (e.g. \"c:\\absolute\\path\\to\\my\\HTMLSuite.html\")");
                    System.err.println("* resultFile (e.g. \"c:\\absolute\\path\\to\\my\\results.html\")");
                    System.exit(1);
                }
                configuration.setHTMLSuite(true);
                continue;
            }
            if ("-interactive".equalsIgnoreCase(arg)) {
                configuration.setTimeoutInSeconds(Integer.MAX_VALUE);
                configuration.setInteractive(true);
                continue;
            }
            if ("-honor-system-proxy".equals(arg)) {
                configuration.setHonorSystemProxy(true);
                continue;
            }
            if (!arg.startsWith("-D")) continue;
            RemoteControlLauncher.setSystemProperty(arg);
        }
        if (configuration.userJSInjection() && !configuration.getProxyInjectionModeArg()) {
            System.err.println("User js injection can only be used w/ -proxyInjectionMode");
            System.exit(1);
        }
        if (configuration.getProfilesLocation() != null && configuration.getFirefoxProfileTemplate() != null) {
            System.err.println("Cannot specify both a profileDirectory and a firefoxProfileTemplate");
            System.exit(1);
        }
        if (null == configuration.getForcedBrowserMode()) {
            if (null != System.getProperty("selenium.defaultBrowserString")) {
                System.err.println("The selenium.defaultBrowserString property is no longer supported; use selenium.forcedBrowserMode instead.");
                System.exit(-1);
            }
            configuration.setForcedBrowserMode(System.getProperty("selenium.forcedBrowserMode"));
        }
        if (!configuration.getProxyInjectionModeArg() && System.getProperty("selenium.proxyInjectionMode") != null) {
            configuration.setProxyInjectionModeArg("true".equals(System.getProperty("selenium.proxyInjectionMode")));
        }
        if (!configuration.isBrowserSideLogEnabled() && System.getProperty("selenium.browserSideLog") != null) {
            configuration.setBrowserSideLogEnabled("true".equals(System.getProperty("selenium.browserSideLog")));
        }
        if (!configuration.isDebugMode() && System.getProperty("selenium.debugMode") != null) {
            configuration.setDebugMode("true".equals(System.getProperty("selenium.debugMode")));
        }
        return configuration;
    }

    public static String getArg(String[] args, int i) {
        if (i >= args.length) {
            RemoteControlLauncher.usage("expected at least one more argument");
            System.exit(-1);
        }
        return args[i];
    }

    public static void printWrappedErrorLine(String prefix, String msg) {
        RemoteControlLauncher.printWrappedErrorLine(prefix, msg, true);
    }

    public static void printWrappedErrorLine(String prefix, String msg, boolean first) {
        int defaultWrap;
        int wrap;
        System.err.print(prefix);
        if (!first) {
            System.err.print("  ");
        }
        if ((wrap = (defaultWrap = 70) - prefix.length()) > msg.length()) {
            System.err.println(msg);
            return;
        }
        String lineRaw = msg.substring(0, wrap);
        int spaceIndex = lineRaw.lastIndexOf(32);
        if (spaceIndex == -1) {
            spaceIndex = lineRaw.length();
        }
        String line = lineRaw.substring(0, spaceIndex);
        System.err.println(line);
        RemoteControlLauncher.printWrappedErrorLine(prefix, msg.substring(spaceIndex + 1), false);
    }

    public static void setSystemProperty(String arg) {
        if (arg.indexOf(61) == -1) {
            RemoteControlLauncher.usage("poorly formatted Java property setting (I expect to see '=') " + arg);
            System.exit(1);
        }
        String property = arg.replaceFirst("-D", "").replaceFirst("=.*", "");
        String value = arg.replaceFirst("[^=]*=", "");
        System.err.println("Setting system property " + property + " to " + value);
        System.setProperty(property, value);
    }
}

