/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import java.io.IOException;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class TracedHttpClient
implements HttpClient {
    private final Tracer tracer;
    private final HttpClient delegate;

    private TracedHttpClient(Tracer tracer, HttpClient delegate) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.delegate = (HttpClient)Require.nonNull((String)"Actual handler", (Object)delegate);
    }

    public WebSocket openSocket(org.openqa.selenium.remote.http.HttpRequest request, WebSocket.Listener listener) {
        return this.delegate.openSocket(request, listener);
    }

    public HttpResponse execute(org.openqa.selenium.remote.http.HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "httpclient.execute");){
            Tags.KIND.accept(span, Span.Kind.CLIENT);
            Tags.HTTP_REQUEST.accept(span, req);
            this.tracer.getPropagator().inject(span, req, (r, key, value) -> r.setHeader(key, value));
            HttpResponse response = this.delegate.execute(req);
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }

    public <T> CompletableFuture<java.net.http.HttpResponse<T>> sendAsyncNative(HttpRequest request, HttpResponse.BodyHandler<T> handler) {
        return this.delegate.sendAsyncNative(request, handler);
    }

    public <T> java.net.http.HttpResponse<T> sendNative(HttpRequest request, HttpResponse.BodyHandler<T> handler) throws IOException, InterruptedException {
        return this.delegate.sendNative(request, handler);
    }

    public void close() {
        this.delegate.close();
    }

    public static class Factory
    implements HttpClient.Factory {
        private final Tracer tracer;
        private final HttpClient.Factory delegate;

        public Factory(Tracer tracer, HttpClient.Factory delegate) {
            this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
            this.delegate = (HttpClient.Factory)Require.nonNull((String)"Actual handler", (Object)delegate);
        }

        public HttpClient createClient(ClientConfig config) {
            HttpClient client = this.delegate.createClient(config);
            return new TracedHttpClient(this.tracer, client);
        }

        public HttpClient createClient(URL url) {
            HttpClient client = this.delegate.createClient(url);
            return new TracedHttpClient(this.tracer, client);
        }
    }
}

