/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class IsEditable
extends SeleneseCommand<Boolean> {
    private final ElementFinder finder;

    public IsEditable(ElementFinder finder) {
        this.finder = finder;
    }

    @Override
    protected Boolean handleSeleneseCommand(WebDriver driver, String locator, String value) {
        WebElement element = this.finder.findElement(driver, locator);
        String tagName = element.getTagName().toLowerCase();
        boolean acceptableTagName = "input".equals(tagName) || "select".equals(tagName);
        String readonly = "";
        if ("input".equals(tagName) && ((readonly = element.getAttribute("readonly")) == null || "false".equals(readonly))) {
            readonly = "";
        }
        return element.isEnabled() && acceptableTagName && "".equals(readonly);
    }
}

