/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class PullImage {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(PullImage.class.getName());
    private final HttpHandler client;
    private final String apiVersion;

    public PullImage(HttpHandler client, String apiVersion) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
        this.apiVersion = (String)Require.nonNull((String)"API version", (Object)apiVersion);
    }

    public void apply(Reference ref) {
        Require.nonNull((String)"Reference to pull", (Object)ref);
        LOG.info("Pulling " + String.valueOf(ref));
        String image = String.format("%s/%s", ref.getDomain(), ref.getName());
        HttpRequest req = ((HttpRequest)new HttpRequest(HttpMethod.POST, String.format("/v%s/images/create", this.apiVersion)).addHeader("Content-Type", "application/json; charset=utf-8")).addQueryParameter("fromImage", image).addQueryParameter("platform", ref.getPlatform());
        if (ref.getDigest() != null) {
            req.addQueryParameter("tag", ref.getDigest());
        } else if (ref.getTag() != null) {
            req.addQueryParameter("tag", ref.getTag());
        }
        HttpResponse res = this.client.execute(req);
        LOG.info("Have response from server");
        if (!res.isSuccessful()) {
            Object message = "Unable to pull image: " + ref.getFamiliarName();
            try {
                Map value = (Map)JSON.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE);
                message = (String)value.get("message");
            }
            catch (Exception e) {
                LOG.fine("Failed to parse error response from Docker daemon for image " + ref.getFamiliarName() + ": " + e.getMessage());
            }
            throw new DockerException((String)message);
        }
    }
}

