/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class IsContainerPresent {
    private final HttpHandler client;
    private final String apiVersion;

    public IsContainerPresent(HttpHandler client, String apiVersion) {
        this.client = (HttpHandler)Require.nonNull((String)"Http client", (Object)client);
        this.apiVersion = (String)Require.nonNull((String)"API version", (Object)apiVersion);
    }

    public boolean apply(ContainerId id) {
        Require.nonNull((String)"Container id", (Object)id);
        HttpResponse res = this.client.execute((HttpRequest)new HttpRequest(HttpMethod.GET, String.format("/v%s/containers/%s/json", this.apiVersion, id)).addHeader("Content-Type", "text/plain"));
        return res.isSuccessful();
    }
}

