/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.preload.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v144.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v144.network.model.LoaderId;
import org.openqa.selenium.devtools.v144.network.model.RequestId;
import org.openqa.selenium.devtools.v144.preload.model.RuleSetErrorType;
import org.openqa.selenium.devtools.v144.preload.model.RuleSetId;
import org.openqa.selenium.json.JsonInput;

public class RuleSet {
    private final RuleSetId id;
    private final LoaderId loaderId;
    private final String sourceText;
    private final Optional<BackendNodeId> backendNodeId;
    private final Optional<String> url;
    private final Optional<RequestId> requestId;
    private final Optional<RuleSetErrorType> errorType;
    private final Optional<String> errorMessage;
    private final Optional<String> tag;

    public RuleSet(RuleSetId id, LoaderId loaderId, String sourceText, Optional<BackendNodeId> backendNodeId, Optional<String> url, Optional<RequestId> requestId, Optional<RuleSetErrorType> errorType, Optional<String> errorMessage, Optional<String> tag) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.sourceText = Objects.requireNonNull(sourceText, "sourceText is required");
        this.backendNodeId = backendNodeId;
        this.url = url;
        this.requestId = requestId;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.tag = tag;
    }

    public RuleSetId getId() {
        return this.id;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public Optional<BackendNodeId> getBackendNodeId() {
        return this.backendNodeId;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<RequestId> getRequestId() {
        return this.requestId;
    }

    public Optional<RuleSetErrorType> getErrorType() {
        return this.errorType;
    }

    @Deprecated
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    private static RuleSet fromJson(JsonInput input) {
        RuleSetId id = null;
        LoaderId loaderId = null;
        String sourceText = null;
        Optional<BackendNodeId> backendNodeId = Optional.empty();
        Optional<String> url = Optional.empty();
        Optional<RequestId> requestId = Optional.empty();
        Optional<RuleSetErrorType> errorType = Optional.empty();
        Optional<String> errorMessage = Optional.empty();
        Optional<String> tag = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (RuleSetId)input.read(RuleSetId.class);
                    continue block22;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block22;
                }
                case "sourceText": {
                    sourceText = input.nextString();
                    continue block22;
                }
                case "backendNodeId": {
                    backendNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block22;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "requestId": {
                    requestId = Optional.ofNullable((RequestId)input.read(RequestId.class));
                    continue block22;
                }
                case "errorType": {
                    errorType = Optional.ofNullable((RuleSetErrorType)((Object)input.read(RuleSetErrorType.class)));
                    continue block22;
                }
                case "errorMessage": {
                    errorMessage = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "tag": {
                    tag = Optional.ofNullable(input.nextString());
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RuleSet(id, loaderId, sourceText, backendNodeId, url, requestId, errorType, errorMessage, tag);
    }
}

