/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.IOException;
import java.lang.reflect.Field;
import org.openqa.selenium.IOUtils;
import org.openqa.selenium.Platform;

public class ProcessUtils {
    public static int waitForProcessDeath(Process p, long timeout) {
        ProcessWaiter pw = new ProcessWaiter(p);
        Thread waiter = new Thread(pw);
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for process", e);
        }
        if (waiter.isAlive()) {
            waiter.interrupt();
        }
        try {
            waiter.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for dead process waiter", e);
        }
        InterruptedException ie = pw.getException();
        if (ie != null) {
            throw new ProcessStillAliveException("Timeout waiting for process to die", ie);
        }
        return p.exitValue();
    }

    public static int killProcess(Process process) {
        int exitValue;
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 1000L);
            if (exitValue == 0) {
                return exitValue;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        process.destroy();
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
        }
        catch (ProcessStillAliveException ex) {
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                throw ex;
            }
            try {
                System.out.println("Process didn't die after 10 seconds");
                ProcessUtils.kill9(process);
                exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
            }
            catch (Exception e) {
                System.out.println("Process refused to die after 10 seconds, and couldn't kill9 it");
                e.printStackTrace();
                throw new RuntimeException("Process refused to die after 10 seconds, and couldn't kill9 it: " + e.getMessage(), ex);
            }
        }
        return exitValue;
    }

    public static int getProcessId(Process p) {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            throw new IllegalStateException("UnixUtils may not be used on Windows");
        }
        try {
            Field f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            Integer pid = (Integer)f.get(p);
            return pid;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't detect pid", e);
        }
    }

    public static void kill9(Integer pid) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("kill", "-9", pid.toString());
        pb.redirectErrorStream();
        Process p = pb.start();
        int code = p.waitFor();
        if (code != 0) {
            String output = IOUtils.readFully(p.getInputStream());
            throw new RuntimeException("kill return code " + code + ": " + output);
        }
    }

    public static void kill9(Process p) throws IOException, InterruptedException {
        ProcessUtils.kill9(ProcessUtils.getProcessId(p));
    }

    public static class ProcessStillAliveException
    extends RuntimeException {
        public ProcessStillAliveException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ProcessWaiter
    implements Runnable {
        private volatile InterruptedException t;
        private final Process p;

        public InterruptedException getException() {
            return this.t;
        }

        public ProcessWaiter(Process p) {
            this.p = p;
        }

        public void run() {
            try {
                this.p.waitFor();
            }
            catch (InterruptedException e) {
                this.t = e;
            }
        }
    }
}

