/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.DriverProvider;
import org.openqa.selenium.android.library.ReflexionHelper;
import org.openqa.selenium.android.library.ViewProvider;
import org.openqa.selenium.android.library.WebDriverView;

public class ChromeClientWrapper
implements DriverProvider,
ViewProvider {
    private final String className;
    private final Object client;

    public ChromeClientWrapper(String className, Object client) {
        this.className = className;
        this.client = client;
    }

    Class getClassForUnderlyingClient() {
        try {
            return Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new WebDriverException("Failed to get class for underlying view with class name: " + this.className, (Throwable)e);
        }
    }

    Object getUnderlyingClient() {
        return this.client;
    }

    public void setDriver(AndroidWebDriver driver) {
        Class[] argsClass = new Class[]{AndroidWebDriver.class};
        Object[] args = new Object[]{driver};
        ReflexionHelper.invoke(this.client, "setDriver", argsClass, args);
    }

    public void setWebDriverView(WebDriverView view) {
        Class[] argsClass = new Class[]{WebDriverView.class};
        Object[] args = new Object[]{view};
        ReflexionHelper.invoke(this.client, "setWebDriverView", argsClass, args);
    }
}

