/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.server.tjws;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.resteasy.util.Encode;
import org.resteasy.util.HttpServletRequestDelegate;

public class PatchedHttpServletRequest
extends HttpServletRequestDelegate {
    private URI encodedURI;
    private URL encodedURL;
    private String contextPath;

    public PatchedHttpServletRequest(HttpServletRequest delegate, String contextPath) {
        super(delegate);
        this.contextPath = contextPath;
        URL url = null;
        try {
            url = new URL(delegate.getRequestURL().toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String buf = PatchedHttpServletRequest.extractURI(url);
        try {
            this.encodedURI = URI.create(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create URI: " + buf, e);
        }
        try {
            this.encodedURL = new URL(this.encodedURI.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractURI(URL url) {
        StringBuffer buffer = new StringBuffer(url.getProtocol()).append("://");
        if (url.getHost() != null) {
            buffer.append(url.getHost());
        }
        if (url.getPort() != -1 && url.getPort() != 80) {
            buffer.append(":").append(Integer.toString(url.getPort()));
        }
        if (url.getPath() != null) {
            buffer.append(Encode.encodePath(url.getPath(), false).replace("%3B", ";").replace("%3D", "="));
        }
        if (url.getQuery() != null) {
            buffer.append("?").append(url.getQuery());
        }
        if (url.getRef() != null) {
            buffer.append("#").append(Encode.encodeSegment(url.getRef()));
        }
        String buf = buffer.toString();
        return buf;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getRequestURI() {
        return this.encodedURI.getRawPath();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.encodedURL.toString());
    }
}

