/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.resteasy.Failure;
import org.resteasy.ResourceInvoker;
import org.resteasy.ResourceMethodRegistry;
import org.resteasy.specimpl.PathSegmentImpl;
import org.resteasy.specimpl.RequestImpl;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.Registry;
import org.resteasy.spi.ResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher {
    protected ResteasyProviderFactory providerFactory;
    protected ResourceMethodRegistry registry;
    protected Map<String, MediaType> mediaTypeMappings;
    protected Map<String, String> languageMappings;

    public Dispatcher(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.registry = new ResourceMethodRegistry(providerFactory);
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings = languageMappings;
    }

    public Map<String, MediaType> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    public Map<String, String> getLanguageMappings() {
        return this.languageMappings;
    }

    protected void preprocess(HttpRequest in) {
        if (this.mediaTypeMappings == null && this.languageMappings == null) {
            return;
        }
        List segments = in.getUri().getPathSegments(false);
        PathSegment last = (PathSegment)segments.get(segments.size() - 1);
        int index = last.getPath().indexOf(46);
        if (index == -1) {
            return;
        }
        String extension = last.getPath().substring(index + 1);
        String[] extensions = extension.split("\\.");
        boolean preprocessed = false;
        String rebuilt = last.getPath().substring(0, index);
        for (String ext : extensions) {
            Object match;
            if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                in.getHttpHeaders().getAcceptableMediaTypes().add(match);
                preprocessed = true;
                continue;
            }
            if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                in.getHttpHeaders().getAcceptableLanguages().add(match);
                preprocessed = true;
                continue;
            }
            rebuilt = rebuilt + "." + ext;
        }
        if (!preprocessed) {
            return;
        }
        String newPath = last.getPath().substring(0, index) + rebuilt;
        ArrayList<PathSegment> newSegments = new ArrayList<PathSegment>(segments.size());
        for (PathSegment segment : segments) {
            newSegments.add(segment);
        }
        PathSegmentImpl newSegment = new PathSegmentImpl(rebuilt, (MultivaluedMap<String, String>)last.getMatrixParameters());
        newSegments.set(newSegments.size() - 1, newSegment);
        in.setPreProcessedSegments(newSegments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpRequest in, HttpResponse response) {
        this.preprocess(in);
        ResourceInvoker invoker = null;
        try {
            invoker = this.registry.getResourceInvoker(in, response);
        }
        catch (Failure e) {
            try {
                response.sendError(e.getErrorCode());
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
            e.printStackTrace();
            return;
        }
        if (invoker == null) {
            try {
                response.sendError(404);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        try {
            ResteasyProviderFactory.pushContext(HttpRequest.class, in);
            ResteasyProviderFactory.pushContext(HttpResponse.class, response);
            ResteasyProviderFactory.pushContext(HttpHeaders.class, in.getHttpHeaders());
            ResteasyProviderFactory.pushContext(UriInfo.class, in.getUri());
            ResteasyProviderFactory.pushContext(Request.class, new RequestImpl(in.getHttpHeaders(), in.getHttpMethod()));
            try {
                invoker.invoke(in, response);
            }
            catch (Failure e) {
                try {
                    response.sendError(e.getErrorCode());
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                e.printStackTrace();
                ResteasyProviderFactory.clearContextData();
                return;
            }
        }
        catch (Exception e) {
            response.setStatus(500);
            e.printStackTrace();
            return;
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }
}

