/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.spotlight;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.spotlight.Spotlight;
import org.primefaces.renderkit.CoreRenderer;

public class SpotlightRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        this.encodeMarkup(fc, component);
        this.encodeScript(fc, component);
    }

    protected void encodeMarkup(FacesContext fc, UIComponent component) throws IOException {
        Spotlight spotlight = (Spotlight)component;
        ResponseWriter writer = fc.getResponseWriter();
        writer.startElement("div", (UIComponent)spotlight);
        writer.writeAttribute("id", (Object)spotlight.getClientId(fc), null);
        writer.writeAttribute("class", (Object)StringUtils.trim((String)("pe-lock-panel " + spotlight.getStyleClass())), "styleClass");
        String style = spotlight.getStyle();
        if (!StringUtils.isBlank((CharSequence)style)) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.renderChildren(fc, component);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        Spotlight spotlight = (Spotlight)component;
        String clientId = spotlight.getClientId(fc);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        String widgetVar = spotlight.resolveWidgetVar();
        writer.write("PrimeFacesExt.cw('Spotlight', '" + widgetVar + "',{id:'" + clientId + "', blocked: " + spotlight.isBlocked() + "},true);");
        writer.write("});");
        this.endScript(writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) throws IOException {
    }
}

