/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.resetinput;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import org.primefaces.extensions.component.resetinput.InputsVisitCallback;

public class PreRenderInputListener
implements ComponentSystemEventListener,
Serializable {
    private static final long serialVersionUID = 20111225L;
    private static final Set<VisitHint> VISIT_HINTS = EnumSet.of(VisitHint.SKIP_UNRENDERED);
    private boolean reset = false;

    public void processEvent(ComponentSystemEvent event) {
        if (!this.reset) {
            return;
        }
        UIComponent source = event.getComponent();
        if (!source.isRendered()) {
            return;
        }
        if (source instanceof EditableValueHolder) {
            ((EditableValueHolder)source).resetValue();
        } else {
            InputsVisitCallback visitCallback = new InputsVisitCallback();
            source.visitTree(VisitContext.createVisitContext((FacesContext)FacesContext.getCurrentInstance(), null, VISIT_HINTS), (VisitCallback)visitCallback);
            List<EditableValueHolder> editableValueHolders = visitCallback.getEditableValueHolders();
            for (EditableValueHolder editableValueHolder : editableValueHolders) {
                editableValueHolder.resetValue();
            }
        }
        this.reset = false;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }
}

