/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.codemirror;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.CompleteEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="codemirror/codemirror.js"), @ResourceDependency(library="primefaces-extensions", name="codemirror/codemirror.css"), @ResourceDependency(library="primefaces-extensions", name="codemirror/mode/modes.js")})
public class CodeMirror
extends HtmlInputTextarea
implements ClientBehaviorHolder,
Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.CodeMirror";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.CodeMirrorRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.extensions.component.";
    public static final String EVENT_CHANGE = "change";
    public static final String EVENT_HIGHLIGHT_COMPLETE = "highlightComplete";
    public static final String EVENT_BLUR = "blur";
    public static final String EVENT_FOCUS = "focus";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("change", "highlightComplete", "blur", "focus", "change"));
    private List<String> suggestions = null;

    public CodeMirror() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getTheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.theme), null);
    }

    public void setTheme(String theme) {
        this.setAttribute(PropertyKeys.theme, theme);
    }

    public String getMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mode), null);
    }

    public void setMode(String mode) {
        this.setAttribute(PropertyKeys.mode, mode);
    }

    public String getKeyMap() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.keyMap), null);
    }

    public void setKeyMap(String keyMap) {
        this.setAttribute(PropertyKeys.keyMap, keyMap);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.setAttribute(PropertyKeys.widgetVar, widgetVar);
    }

    public Integer getIndentUnit() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.indentUnit), null);
    }

    public void setIndentUnit(Integer indentUnit) {
        this.setAttribute(PropertyKeys.indentUnit, indentUnit);
    }

    public Integer getTabSize() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabSize), null);
    }

    public void setFirstLineNumber(Integer firstLineNumber) {
        this.setAttribute(PropertyKeys.firstLineNumber, firstLineNumber);
    }

    public Integer getFirstLineNumber() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.firstLineNumber), null);
    }

    public void setTabSize(Integer tabSize) {
        this.setAttribute(PropertyKeys.tabSize, tabSize);
    }

    public Boolean isLineNumbers() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.lineNumbers), null);
    }

    public void setLineNumbers(Boolean lineNumbers) {
        this.setAttribute(PropertyKeys.lineNumbers, lineNumbers);
    }

    public Boolean isSmartIndent() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.smartIndent), null);
    }

    public void setSmartIndent(Boolean smartIndent) {
        this.setAttribute(PropertyKeys.smartIndent, smartIndent);
    }

    public Boolean isReadOnly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readOnly), (Object)false);
    }

    public void setReadOnly(Boolean readOnly) {
        this.setAttribute(PropertyKeys.readOnly, readOnly);
    }

    public Boolean isIndentWithTabs() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.indentWithTabs), null);
    }

    public void setIndentWithTabs(Boolean indentWithTabs) {
        this.setAttribute(PropertyKeys.indentWithTabs, indentWithTabs);
    }

    public Boolean isElectricChars() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.electricChars), null);
    }

    public void setElectricChars(Boolean electricChars) {
        this.setAttribute(PropertyKeys.electricChars, electricChars);
    }

    public Boolean isLineWrapping() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.lineWrapping), null);
    }

    public void setLineWrapping(Boolean lineWrapping) {
        this.setAttribute(PropertyKeys.lineWrapping, lineWrapping);
    }

    public Boolean isGutter() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.gutter), null);
    }

    public void setGutter(Boolean gutter) {
        this.setAttribute(PropertyKeys.gutter, gutter);
    }

    public Boolean isFixedGutter() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fixedGutter), null);
    }

    public void setFixedGutter(Boolean fixedGutter) {
        this.setAttribute(PropertyKeys.fixedGutter, fixedGutter);
    }

    public Boolean isMatchBrackets() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.matchBrackets), null);
    }

    public void setMatchBrackets(Boolean matchBrackets) {
        this.setAttribute(PropertyKeys.matchBrackets, matchBrackets);
    }

    public Integer getWorkTime() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.workTime), null);
    }

    public void setWorkTime(Integer workTime) {
        this.setAttribute(PropertyKeys.workTime, workTime);
    }

    public Integer getWorkDelay() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.workDelay), null);
    }

    public void setWorkDelay(Integer workDelay) {
        this.setAttribute(PropertyKeys.workDelay, workDelay);
    }

    public Integer getPollInterval() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pollInterval), null);
    }

    public void setPollInterval(Integer pollInterval) {
        this.setAttribute(PropertyKeys.pollInterval, pollInterval);
    }

    public Integer getUndoDepth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.undoDepth), null);
    }

    public void setUndoDepth(Integer undoDepth) {
        this.setAttribute(PropertyKeys.undoDepth, undoDepth);
    }

    public String getTabindex() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex), null);
    }

    public void setTabindex(String tabindex) {
        this.setAttribute(PropertyKeys.tabindex, tabindex);
    }

    public String getExtraKeys() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.extraKeys), null);
    }

    public void setExtraKeys(String extraKeys) {
        this.setAttribute(PropertyKeys.extraKeys, extraKeys);
    }

    public MethodExpression getCompleteMethod() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.completeMethod), null);
    }

    public void setCompleteMethod(MethodExpression completeMethod) {
        this.setAttribute(PropertyKeys.completeMethod, completeMethod);
    }

    public String getProcess() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.process), null);
    }

    public void setProcess(String process) {
        this.setAttribute(PropertyKeys.process, process);
    }

    public String getOnstart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onstart), null);
    }

    public void setOnstart(String onstart) {
        this.setAttribute(PropertyKeys.onstart, onstart);
    }

    public String getOncomplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.oncomplete), null);
    }

    public void setOncomplete(String oncomplete) {
        this.setAttribute(PropertyKeys.oncomplete, oncomplete);
    }

    public String getOnerror() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onerror), null);
    }

    public void setOnerror(String onerror) {
        this.setAttribute(PropertyKeys.onerror, onerror);
    }

    public String getOnsuccess() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onsuccess), null);
    }

    public void setOnsuccess(String onsuccess) {
        this.setAttribute(PropertyKeys.onsuccess, onsuccess);
    }

    public boolean isGlobal() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.global), (Object)true);
    }

    public void setGlobal(boolean global) {
        this.setAttribute(PropertyKeys.global, global);
    }

    public boolean isAsync() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.async), (Object)false);
    }

    public void setAsync(boolean async) {
        this.setAttribute(PropertyKeys.async, async);
    }

    public boolean isEscape() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.escape), (Object)true);
    }

    public void setEscape(boolean escape) {
        this.setAttribute(PropertyKeys.escape, escape);
    }

    public boolean isEscapeSuggestions() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.escapeSuggestions), (Object)true);
    }

    public void setEscapeSuggestions(boolean suggestions) {
        this.setAttribute(PropertyKeys.escapeSuggestions, suggestions);
    }

    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get(PropertyKeys.widgetVar.toString());
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void setAttribute(PropertyKeys property, Object value) {
        String cname;
        this.getStateHelper().put((Serializable)((Object)property), value);
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = ((Object)((Object)this)).getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            String attributeName = property.toString();
            ValueExpression ve = this.getValueExpression(attributeName);
            if (ve == null) {
                setAttributes.remove(attributeName);
            } else if (!setAttributes.contains(attributeName)) {
                setAttributes.add(attributeName);
            }
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MethodExpression completeMethod = this.getCompleteMethod();
        if (completeMethod != null && event instanceof CompleteEvent) {
            CompleteEvent completeEvent = (CompleteEvent)event;
            this.suggestions = (List)completeMethod.invoke(facesContext.getELContext(), new Object[]{completeEvent.getToken(), completeEvent.getContext()});
            if (this.suggestions == null) {
                this.suggestions = new ArrayList<String>();
            }
            facesContext.renderResponse();
        }
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        theme,
        mode,
        indentUnit,
        smartIndent,
        tabSize,
        indentWithTabs,
        electricChars,
        keyMap,
        lineWrapping,
        lineNumbers,
        firstLineNumber,
        gutter,
        fixedGutter,
        readOnly,
        matchBrackets,
        workTime,
        workDelay,
        pollInterval,
        undoDepth,
        tabindex,
        extraKeys,
        completeMethod,
        process,
        onstart,
        oncomplete,
        onerror,
        onsuccess,
        global,
        async,
        escape,
        escapeSuggestions;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

