/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.base;

import java.io.Serializable;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import org.primefaces.extensions.event.EventDataWrapper;
import org.primefaces.extensions.model.common.KeyData;
import org.primefaces.extensions.util.SavedEditableValueState;

public abstract class AbstractDynamicData
extends UIComponentBase
implements NamingContainer,
UniqueIdVendor {
    protected static final String OPTIMIZED_PACKAGE = "org.primefaces.extensions.component.";
    protected KeyData data;

    public String getVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)var);
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(Object value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
    }

    protected abstract KeyData findData(String var1);

    protected abstract void processChildren(FacesContext var1, PhaseId var2);

    protected abstract boolean visitChildren(VisitContext var1, VisitCallback var2);

    protected abstract boolean invokeOnChildren(FacesContext var1, String var2, ContextCallback var3);

    public void setData(String key) {
        if (this.data != null) {
            this.saveDescendantState();
        }
        this.data = this.findData(key);
        this.exposeVar();
        if (this.data != null) {
            this.restoreDescendantState();
        }
    }

    public void setData(KeyData keyData) {
        if (this.data != null) {
            this.saveDescendantState();
        }
        this.data = keyData;
        this.exposeVar();
        if (this.data != null) {
            this.restoreDescendantState();
        }
    }

    public void resetData() {
        if (this.data != null) {
            this.saveDescendantState();
        }
        this.data = null;
        this.exposeVar();
    }

    public KeyData getData() {
        return this.data;
    }

    public String getContainerClientId(FacesContext context) {
        String key;
        String clientId = super.getContainerClientId(context);
        KeyData data = this.getData();
        String string = key = data != null ? data.getKey() : null;
        if (key == null) {
            return clientId;
        }
        StringBuilder builder = new StringBuilder();
        return builder.append(clientId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(key).toString();
    }

    public void processDecodes(FacesContext context) {
        boolean hasErrors;
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        FacesMessage.Severity sev = context.getMaximumSeverity();
        boolean bl = hasErrors = sev != null && FacesMessage.SEVERITY_ERROR.compareTo((Object)sev) >= 0;
        if (saved == null) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved));
        } else if (!hasErrors) {
            for (SavedEditableValueState saveState : saved.values()) {
                saveState.reset();
            }
        }
        this.processFacets(context, PhaseId.APPLY_REQUEST_VALUES, (UIComponent)this);
        this.processChildren(context, PhaseId.APPLY_REQUEST_VALUES);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, (Object)this);
        this.processFacets(context, PhaseId.PROCESS_VALIDATIONS, (UIComponent)this);
        this.processChildren(context, PhaseId.PROCESS_VALIDATIONS);
        app.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        this.processFacets(context, PhaseId.UPDATE_MODEL_VALUES, (UIComponent)this);
        this.processChildren(context, PhaseId.UPDATE_MODEL_VALUES);
        this.popComponentFromEL(context);
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new EventDataWrapper((UIComponent)this, event, this.getData()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof EventDataWrapper)) {
            super.broadcast(event);
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        KeyData oldData = this.getData();
        EventDataWrapper eventDataWrapper = (EventDataWrapper)event;
        FacesEvent originalEvent = eventDataWrapper.getFacesEvent();
        UIComponent originalSource = (UIComponent)originalEvent.getSource();
        this.setData(eventDataWrapper.getData());
        UIComponent compositeParent = null;
        try {
            if (!UIComponent.isCompositeComponent((UIComponent)originalSource)) {
                compositeParent = AbstractDynamicData.getCompositeComponentParent((UIComponent)originalSource);
            }
            if (compositeParent != null) {
                compositeParent.pushComponentToEL(context, null);
            }
            originalSource.pushComponentToEL(context, null);
            originalSource.broadcast(originalEvent);
        }
        finally {
            originalSource.popComponentFromEL(context);
            if (compositeParent != null) {
                compositeParent.popComponentFromEL(context);
            }
        }
        this.setData(oldData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block10: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext fc = context.getFacesContext();
            KeyData oldData = this.getData();
            this.resetData();
            this.pushComponentToEL(fc, null);
            try {
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT || context.getSubtreeIdsToVisit((UIComponent)this).isEmpty()) break block10;
                if (this.getFacetCount() > 0) {
                    for (UIComponent facet : this.getFacets().values()) {
                        if (!facet.visitTree(context, callback)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                if (this.visitChildren(context, callback)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(fc);
                this.setData(oldData);
            }
        }
        return false;
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) {
        KeyData oldData = this.getData();
        this.resetData();
        try {
            if (clientId.equals(super.getClientId(context))) {
                this.pushComponentToEL(context, AbstractDynamicData.getCompositeComponentParent((UIComponent)this));
                callback.invokeContextCallback(context, (UIComponent)this);
                boolean bl = true;
                return bl;
            }
            if (this.getFacetCount() > 0) {
                for (UIComponent c : this.getFacets().values()) {
                    if (!clientId.equals(c.getClientId(context))) continue;
                    callback.invokeContextCallback(context, c);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean i$ = this.invokeOnChildren(context, clientId, callback);
            return i$;
        }
        catch (FacesException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this.popComponentFromEL(context);
            this.setData(oldData);
        }
    }

    protected void processFacets(FacesContext context, PhaseId phaseId, UIComponent component) {
        this.resetData();
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    facet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    facet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    facet.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public String createUniqueId(FacesContext context, String seed) {
        Integer i = (Integer)this.getStateHelper().get((Serializable)((Object)PropertyKeys.lastId));
        int lastId = i != null ? i : 0;
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastId), (Object)(++lastId));
        return "j_id" + (seed == null ? Integer.valueOf(lastId) : seed);
    }

    protected void exposeVar() {
        KeyData keyData = this.getData();
        Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        if (keyData == null) {
            requestMap.remove(this.getVar());
        } else {
            requestMap.put(this.getVar(), keyData.getData());
        }
    }

    protected void saveDescendantState() {
        for (UIComponent child : this.getChildren()) {
            this.saveDescendantState(FacesContext.getCurrentInstance(), child);
        }
    }

    protected void saveDescendantState(FacesContext context, UIComponent component) {
        component.setId(component.getId());
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            SavedEditableValueState state = null;
            String clientId = component.getClientId(context);
            if (saved == null) {
                state = new SavedEditableValueState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, (Object)state);
            }
            if (state == null && (state = (SavedEditableValueState)saved.get(clientId)) == null) {
                state = new SavedEditableValueState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, (Object)state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
            state.setLabelValue(((UIComponent)input).getAttributes().get("label"));
        }
        for (UIComponent child : component.getChildren()) {
            this.saveDescendantState(context, child);
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.saveDescendantState(context, facet);
            }
        }
    }

    protected void restoreDescendantState() {
        for (UIComponent child : this.getChildren()) {
            this.restoreDescendantState(FacesContext.getCurrentInstance(), child);
        }
    }

    protected void restoreDescendantState(FacesContext context, UIComponent component) {
        component.setId(component.getId());
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (saved == null) {
            return;
        }
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedEditableValueState state = (SavedEditableValueState)saved.get(clientId);
            if (state == null) {
                state = new SavedEditableValueState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
            if (state.getLabelValue() != null) {
                ((UIComponent)input).getAttributes().put("label", state.getLabelValue());
            }
        }
        for (UIComponent child : component.getChildren()) {
            this.restoreDescendantState(context, child);
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.restoreDescendantState(context, facet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        saved,
        lastId,
        var,
        value;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

