/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.ajaxerrorhandler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ExceptionQueuedEvent;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.primefaces.extensions.component.ajaxerrorhandler.AjaxErrorHandlerVisitCallback;

public class AjaxExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger LOGGER = Logger.getLogger(AjaxExceptionHandler.class.getCanonicalName());
    private ExceptionHandler wrapped = null;

    public AjaxExceptionHandler(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        Iterable exceptionQueuedEvents;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext() != null && context.getPartialViewContext().isAjaxRequest() && (exceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents()) != null && exceptionQueuedEvents.iterator() != null) {
            Iterator unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
            if (unhandledExceptionQueuedEvents.hasNext()) {
                Throwable exception = ((ExceptionQueuedEvent)unhandledExceptionQueuedEvents.next()).getContext().getException();
                unhandledExceptionQueuedEvents.remove();
                this.handlePartialResponseError(context, exception);
            }
            while (unhandledExceptionQueuedEvents.hasNext()) {
                unhandledExceptionQueuedEvents.next();
                unhandledExceptionQueuedEvents.remove();
            }
        }
        this.wrapped.handle();
    }

    private void handlePartialResponseError(FacesContext context, Throwable t) {
        block15: {
            if (context.getResponseComplete()) {
                return;
            }
            if (!context.getExternalContext().isResponseCommitted()) {
                context.getExternalContext().responseReset();
            }
            try {
                List<UIComponent> customContent;
                UIComponent bodyFacet;
                UIComponent titleFacet;
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
                String errorName = rootCause == null ? t.getClass().getCanonicalName() : rootCause.getClass().getCanonicalName();
                ExternalContext extContext = context.getExternalContext();
                extContext.setResponseContentType("text/xml");
                extContext.addResponseHeader("Cache-Control", "no-cache");
                PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                writer.startDocument();
                writer.startElement("error", null);
                writer.startElement("error-name", null);
                writer.write(errorName);
                writer.endElement("error-name");
                writer.startElement("error-message", null);
                writer.startCDATA();
                writer.write(rootCause != null ? rootCause.getMessage() : t.getMessage());
                writer.endCDATA();
                writer.endElement("error-message");
                writer.startElement("error-stacktrace", null);
                writer.startCDATA();
                String stackTrace = ExceptionUtils.getStackTrace((Throwable)(rootCause == null ? t : rootCause));
                writer.write(stackTrace);
                writer.endCDATA();
                writer.endElement("error-stacktrace");
                writer.startElement("error-hostname", null);
                writer.write(this.getHostname());
                writer.endElement("error-hostname");
                UIViewRoot root = context.getViewRoot();
                AjaxErrorHandlerVisitCallback visitCallback = new AjaxErrorHandlerVisitCallback(errorName);
                if (root != null) {
                    root.visitTree(VisitContext.createVisitContext((FacesContext)context), (VisitCallback)visitCallback);
                }
                if ((titleFacet = visitCallback.findCurrentTitleFacet()) != null) {
                    writer.startElement("updateTitle", null);
                    writer.startCDATA();
                    try {
                        context.setResponseWriter((ResponseWriter)writer);
                        titleFacet.encodeAll(context);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Rendering titleUpdate in AjaxExceptionHandler throws exception!", e);
                        writer.write("<exception />");
                    }
                    writer.endCDATA();
                    writer.endElement("updateTitle");
                }
                if ((bodyFacet = visitCallback.findCurrentBodyFacet()) != null) {
                    writer.startElement("updateBody", null);
                    writer.startCDATA();
                    try {
                        context.setResponseWriter((ResponseWriter)writer);
                        bodyFacet.encodeAll(context);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Rendering bodyUpdate in AjaxExceptionHandler throws exception!", e);
                        writer.write("<exception />");
                    }
                    writer.endCDATA();
                    writer.endElement("updateBody");
                }
                if ((customContent = visitCallback.findCurrentChildren()) != null && customContent.size() > 0) {
                    writer.startElement("updateCustomContent", null);
                    writer.startCDATA();
                    try {
                        context.setResponseWriter((ResponseWriter)writer);
                        for (UIComponent component : customContent) {
                            component.encodeAll(context);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Rendering updateCustomContent in AjaxExceptionHandler throws exception!", e);
                        writer.write("<exception />");
                    }
                    writer.endCDATA();
                    writer.endElement("updateCustomContent");
                }
                writer.endElement("error");
                writer.endDocument();
                context.responseComplete();
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block15;
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected String getHostname() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "???unknown???";
        }
    }
}

