/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.behavior.ajax.AjaxBehavior;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.component.commandlink.CommandLink;
import org.primefaces.component.hotkey.Hotkey;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.splitbutton.SplitButton;
import org.primefaces.extensions.component.base.Attachable;
import org.primefaces.extensions.component.base.EnhancedAttachable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtils
extends org.primefaces.util.ComponentUtils {
    private static final Logger LOG = Logger.getLogger(ComponentUtils.class.getName());

    private ComponentUtils() {
    }

    public static String escapeComponentId(String id) {
        return id.replaceAll(":", "\\\\\\\\:");
    }

    public static List<UIComponent> findComponents(FacesContext context, UIComponent source, String list) {
        ArrayList<UIComponent> foundComponents = new ArrayList<UIComponent>();
        String[] ids = list.split("[\\s,]+");
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            if (id.equals("@this")) {
                foundComponents.add(source);
                continue;
            }
            if (id.equals("@form")) {
                UIComponent form = ComponentUtils.findParentForm((FacesContext)context, (UIComponent)source);
                if (form != null) {
                    foundComponents.add(form);
                    continue;
                }
                if (!context.isProjectStage(ProjectStage.Development)) continue;
                LOG.log(Level.INFO, "Cannot find enclosing form for component \"{0}\".", source.getClientId(context));
                continue;
            }
            if (id.equals("@parent")) {
                foundComponents.add(source.getParent());
                continue;
            }
            if (id.equals("@all") || id.equals("@none")) {
                LOG.log(Level.WARNING, "Components @all and @none are not supported.");
                continue;
            }
            UIComponent component = source.findComponent(id);
            if (component != null) {
                foundComponents.add(component);
                continue;
            }
            if (!context.isProjectStage(ProjectStage.Development)) continue;
            LOG.log(Level.WARNING, "Cannot find component with identifier \"{0}\" in view.", id);
        }
        return foundComponents;
    }

    public static String findTarget(FacesContext context, Attachable attachable) {
        if (!(attachable instanceof UIComponent)) {
            throw new FacesException("An attachable component must extend UIComponent or ClientBehavior.");
        }
        return ComponentUtils.findTarget(context, attachable, (UIComponent)attachable);
    }

    public static String findTarget(FacesContext context, Attachable attachable, ClientBehaviorContext cbContext) {
        if (!(attachable instanceof ClientBehavior)) {
            throw new FacesException("An attachable component must extend UIComponent or ClientBehavior.");
        }
        if (cbContext == null) {
            throw new FacesException("ClientBehaviorContext is null.");
        }
        return ComponentUtils.findTarget(context, attachable, cbContext.getComponent());
    }

    private static String findTarget(FacesContext context, Attachable attachable, UIComponent component) {
        String forSelector;
        String forValue = attachable.getFor();
        if (forValue != null) {
            UIComponent forComponent = component.findComponent(forValue);
            if (forComponent == null) {
                throw new FacesException("Cannot find component '" + forValue + "'.");
            }
            return ComponentUtils.escapeJQueryId((String)forComponent.getClientId(context));
        }
        if (attachable instanceof EnhancedAttachable && (forSelector = ((EnhancedAttachable)attachable).getForSelector()) != null) {
            return forSelector;
        }
        return ComponentUtils.escapeJQueryId((String)component.getParent().getClientId(context));
    }

    public static void addComponentResource(FacesContext context, String name) {
        ComponentUtils.addComponentResource(context, name, "primefaces-extensions", "head");
    }

    public static void addComponentResource(FacesContext context, String name, String library, String target) {
        Application application = context.getApplication();
        UIComponent componentResource = application.createComponent("javax.faces.Output");
        componentResource.setRendererType(application.getResourceHandler().getRendererTypeForResourceName(name));
        componentResource.setTransient(true);
        componentResource.setId(context.getViewRoot().createUniqueId());
        componentResource.getAttributes().put("name", name);
        componentResource.getAttributes().put("library", library);
        componentResource.getAttributes().put("target", target);
        context.getViewRoot().addComponentResource(context, componentResource, target);
    }

    public static String escapeText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static Object getConvertedSubmittedValue(FacesContext fc, EditableValueHolder evh) {
        Object submittedValue = evh.getSubmittedValue();
        if (submittedValue == null) {
            return submittedValue;
        }
        try {
            Converter converter;
            UIComponent component = (UIComponent)evh;
            Renderer renderer = ComponentUtils.getRenderer(fc, component);
            if (renderer != null) {
                return renderer.getConvertedValue(fc, component, submittedValue);
            }
            if (submittedValue instanceof String && (converter = ComponentUtils.getConverter(fc, component)) != null) {
                return converter.getAsObject(fc, component, (String)submittedValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return submittedValue;
    }

    public static Renderer getRenderer(FacesContext fc, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType != null) {
            return fc.getRenderKit().getRenderer(component.getFamily(), rendererType);
        }
        return null;
    }

    public static Converter getConverter(FacesContext fc, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            return null;
        }
        Converter converter = ((EditableValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        Class converterType = valueExpression.getType(fc.getELContext());
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        return fc.getApplication().createConverter(converterType);
    }

    public static boolean isAjaxifiedComponent(UIComponent component) {
        Collection behaviors;
        String type;
        boolean isAjaxified;
        if (component instanceof AjaxSource && (isAjaxified = component instanceof CommandButton ? !(type = ((CommandButton)component).getType()).equals("reset") && !type.equals("button") && ((CommandButton)component).isAjax() : (component instanceof CommandLink ? ((CommandLink)component).isAjax() : (component instanceof MenuItem ? ((MenuItem)component).getUrl() == null && ((MenuItem)component).isAjax() : (component instanceof SplitButton ? ((SplitButton)component).isAjax() : (component instanceof Hotkey ? ((Hotkey)component).getHandler() == null : true)))))) {
            return true;
        }
        if (component instanceof ClientBehaviorHolder && (behaviors = ((ClientBehaviorHolder)component).getClientBehaviors().values()) != null && !behaviors.isEmpty()) {
            for (List listBehaviors : behaviors) {
                for (ClientBehavior clientBehavior : listBehaviors) {
                    if (!(clientBehavior instanceof javax.faces.component.behavior.AjaxBehavior) && !(clientBehavior instanceof AjaxBehavior)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String escapeSelector(String value) {
        StringBuilder builder = new StringBuilder();
        block4: for (char c : value.toCharArray()) {
            switch (c) {
                case '\\': {
                    builder.append("\\\\\\\\");
                    continue block4;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '>': 
                case '[': 
                case ']': 
                case '^': 
                case '|': 
                case '~': {
                    builder.append("\\\\");
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }
}

