/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.renderkit.layout;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.primefaces.extensions.model.layout.LayoutOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutOptionsSerializer
implements JsonSerializer<LayoutOptions> {
    public JsonElement serialize(LayoutOptions src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        Set<Map.Entry<String, Object>> options = src.getOptions().entrySet();
        for (Map.Entry<String, Object> entry : options) {
            Object value = entry.getValue();
            JsonPrimitive jsonPrimitive = null;
            if (value instanceof Boolean) {
                jsonPrimitive = new JsonPrimitive((Boolean)value);
            } else if (value instanceof Number) {
                jsonPrimitive = new JsonPrimitive((Number)value);
            } else if (value instanceof String) {
                jsonPrimitive = new JsonPrimitive((String)entry.getValue());
            }
            result.add(entry.getKey(), (JsonElement)jsonPrimitive);
        }
        if (src.getPanesOptions() != null) {
            result.add("panes", context.serialize((Object)src.getPanesOptions(), src.getPanesOptions().getClass()));
        }
        if (src.getNorthOptions() != null) {
            result.add("north", context.serialize((Object)src.getNorthOptions(), src.getNorthOptions().getClass()));
        }
        if (src.getSouthOptions() != null) {
            result.add("south", context.serialize((Object)src.getSouthOptions(), src.getSouthOptions().getClass()));
        }
        if (src.getWestOptions() != null) {
            result.add("west", context.serialize((Object)src.getWestOptions(), src.getWestOptions().getClass()));
        }
        if (src.getEastOptions() != null) {
            result.add("east", context.serialize((Object)src.getEastOptions(), src.getEastOptions().getClass()));
        }
        if (src.getCenterOptions() != null) {
            result.add("center", context.serialize((Object)src.getCenterOptions(), src.getCenterOptions().getClass()));
        }
        if (src.getChildOptions() != null) {
            result.add("childOptions", context.serialize((Object)src.getChildOptions(), src.getChildOptions().getClass()));
        }
        return result;
    }
}

