/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.dynaform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.primefaces.extensions.model.dynaform.DynaFormControl;
import org.primefaces.extensions.model.dynaform.DynaFormLabel;
import org.primefaces.extensions.model.dynaform.DynaFormRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynaFormModel
implements Serializable {
    private static final long serialVersionUID = 20120514L;
    private String uuid;
    private List<DynaFormRow> regularRows = new ArrayList<DynaFormRow>();
    private List<DynaFormRow> extendedRows = null;
    private List<DynaFormLabel> labels = new ArrayList<DynaFormLabel>();
    private List<DynaFormControl> controls = new ArrayList<DynaFormControl>();

    public DynaFormModel() {
        this.uuid = UUID.randomUUID().toString();
    }

    public String getUuid() {
        return this.uuid;
    }

    public List<DynaFormRow> getRegularRows() {
        return this.regularRows;
    }

    public List<DynaFormRow> getExtendedRows() {
        return this.extendedRows;
    }

    public List<DynaFormControl> getControls() {
        return this.controls;
    }

    public List<DynaFormLabel> getLabels() {
        return this.labels;
    }

    public DynaFormRow createRegularRow() {
        DynaFormRow dynaFormRow = new DynaFormRow(this.regularRows.size() + 1, false, this);
        this.regularRows.add(dynaFormRow);
        return dynaFormRow;
    }

    public DynaFormRow createExtendedRow() {
        if (this.extendedRows == null) {
            this.extendedRows = new ArrayList<DynaFormRow>();
        }
        DynaFormRow dynaFormRow = new DynaFormRow(this.extendedRows.size() + 1, true, this);
        this.extendedRows.add(dynaFormRow);
        return dynaFormRow;
    }

    public boolean isExistExtendedGrid() {
        return this.getExtendedRows() != null && !this.getExtendedRows().isEmpty();
    }
}

