/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.resetinput;

import java.util.List;
import javax.faces.FacesWrapper;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesListener;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEventListener;
import org.primefaces.component.behavior.ajax.AjaxBehaviorListenerImpl;
import org.primefaces.extensions.component.resetinput.PreRenderInputListener;
import org.primefaces.extensions.util.ComponentUtils;

public class ResetInputListener
extends AjaxBehaviorListenerImpl
implements ActionListener,
StateHolder {
    private String components;

    public ResetInputListener() {
    }

    public ResetInputListener(String components) {
        this.components = components;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        this.processReset(event.getComponent());
    }

    public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
        this.processReset(event.getComponent());
    }

    protected void processReset(UIComponent source) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String clientId = source.getClientId(fc);
        if (!clientId.equals(fc.getExternalContext().getRequestParameterMap().get("javax.faces.source"))) {
            return;
        }
        List<UIComponent> foundComponents = ComponentUtils.findComponents(fc, source, this.components);
        for (UIComponent foundComponent : foundComponents) {
            PreRenderInputListener ppevListener = this.getPreRenderEditableValuesListener(foundComponent);
            if (ppevListener == null) {
                ppevListener = new PreRenderInputListener();
                foundComponent.subscribeToEvent(PreRenderComponentEvent.class, (ComponentSystemEventListener)ppevListener);
            }
            ppevListener.setReset(true);
        }
    }

    protected PreRenderInputListener getPreRenderEditableValuesListener(UIComponent component) {
        List systemEventListeners = component.getListenersForEventClass(PreRenderComponentEvent.class);
        if (systemEventListeners != null && !systemEventListeners.isEmpty()) {
            for (SystemEventListener systemEventListener : systemEventListeners) {
                if (systemEventListener instanceof PreRenderInputListener) {
                    return (PreRenderInputListener)systemEventListener;
                }
                FacesListener wrapped = null;
                if (systemEventListener instanceof FacesWrapper) {
                    wrapped = (FacesListener)((FacesWrapper)systemEventListener).getWrapped();
                }
                while (wrapped != null) {
                    if (wrapped instanceof PreRenderInputListener) {
                        return (PreRenderInputListener)wrapped;
                    }
                    if (wrapped instanceof FacesWrapper) {
                        wrapped = (FacesListener)((FacesWrapper)wrapped).getWrapped();
                        continue;
                    }
                    wrapped = null;
                }
            }
        }
        return null;
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.components = (String)values[0];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.components};
        return values;
    }

    public void setTransient(boolean value) {
    }
}

