/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import org.planx.xmlstore.NameServer;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.nameserver.LocalNameServer;
import org.planx.xmlstore.nodes.DVMNodeFactory;
import org.planx.xmlstore.references.ReferenceListener;
import org.planx.xmlstore.regions.RegionConfiguration;
import org.planx.xmlstore.regions.RegionManager;
import org.planx.xmlstore.stores.AbstractXMLStore;

public class LocalXMLStore
extends AbstractXMLStore {
    private String name;
    private RegionManager manager;
    private NameServer nameServer;

    public LocalXMLStore(String name) throws IOException {
        this(name, new RegionConfiguration());
    }

    public LocalXMLStore(String name, RegionConfiguration conf) throws IOException {
        this.name = name;
        this.manager = new RegionManager(this, conf);
        this.nameServer = new LocalNameServer(this);
    }

    @Override
    public Reference save(Node node) throws IOException {
        this.checkClosed();
        return this.manager.save(DVMNodeFactory.convert(node));
    }

    @Override
    protected Node resolvedLoad(Reference vref) throws IOException, UnknownReferenceException {
        this.checkClosed();
        LocalLocator loc = (LocalLocator)vref;
        return this.manager.load(loc);
    }

    public NameServer getNameServer() {
        return this.nameServer;
    }

    public RegionManager getRegionManager() {
        return this.manager;
    }

    public void retain(Reference ref) throws UnknownReferenceException {
        this.manager.retain((LocalLocator)ref);
    }

    public void release(Reference ref) throws UnknownReferenceException {
        this.manager.release((LocalLocator)ref);
    }

    public void addReferenceListener(ReferenceListener listener) {
        this.manager.addRootListener(listener);
    }

    public void removeReferenceListener(ReferenceListener listener) {
        this.manager.removeRootListener(listener);
    }

    public long size() throws IOException {
        return this.manager.size();
    }

    @Override
    public void close() throws IOException {
        this.manager.close();
        this.manager = null;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    protected void checkClosed() {
        if (this.manager == null) {
            throw new IllegalStateException("XMLStore is closed");
        }
    }
}

