/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.util.LinkedList;

public class ThreadPool {
    private Worker[] workers;
    private LinkedList worklist;
    private Done done = new Done();

    public ThreadPool() {
        this(100);
    }

    public ThreadPool(int size) {
        this.workers = new Worker[size];
        this.worklist = new LinkedList();
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new Worker(this, i);
            this.workers[i].start();
        }
    }

    public void stop() {
        this.done.waitUntilDone();
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].interrupt();
        }
    }

    public synchronized void addWork(Runnable work) {
        this.worklist.add(work);
        this.notify();
    }

    private synchronized Runnable getWork() {
        try {
            while (this.worklist.isEmpty()) {
                this.wait();
            }
            Runnable work = (Runnable)this.worklist.removeFirst();
            return work;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private void active(int id) {
        this.done.active();
    }

    private void inactive(int id) {
        this.done.inactive();
    }

    public boolean idle() {
        return this.done.idle();
    }

    private class Worker
    extends Thread {
        ThreadPool coord;
        int id;

        private Worker(ThreadPool coord, int id) {
            this.coord = coord;
            this.id = id;
        }

        @Override
        public void run() {
            Runnable work = null;
            do {
                work = this.coord.getWork();
                this.coord.active(this.id);
                if (work != null) {
                    work.run();
                }
                this.coord.inactive(this.id);
            } while (work != null);
        }
    }

    private class Done {
        private int activeworkers;

        private Done() {
        }

        private synchronized void active() {
            ++this.activeworkers;
            this.notify();
        }

        private synchronized void inactive() {
            if (this.activeworkers > 0) {
                --this.activeworkers;
            }
            this.notify();
        }

        public synchronized boolean idle() {
            return this.activeworkers == 0;
        }

        public synchronized void waitUntilDone() {
            try {
                while (this.activeworkers > 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

