package org.planx.xpath.expr;
import java_cup.runtime.Symbol;


class XPathLexer implements java_cup.runtime.Scanner {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final int YY_BOL = 65536;
	private final int YY_EOF = 65537;
	public final int YYEOF = -1;
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private boolean yy_at_bol;
	private int yy_lexical_state;

	XPathLexer (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	XPathLexer (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private XPathLexer () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yy_at_bol = true;
		yy_lexical_state = YYINITIAL;
	}

	private boolean yy_eof_done = false;
	private final int YYINITIAL = 0;
	private final int yy_state_dtrans[] = {
		0
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private int yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_end () {
		if (yy_buffer_end > yy_buffer_start &&
		    '\n' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
		if (yy_buffer_end > yy_buffer_start &&
		    '\r' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
	}
	private boolean yy_last_was_cr=false;
	private void yy_mark_start () {
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
		yy_at_bol = (yy_buffer_end > yy_buffer_start) &&
		            ('\r' == yy_buffer[yy_buffer_end-1] ||
		             '\n' == yy_buffer[yy_buffer_end-1] ||
		             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||
		             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int[][] unpackFromString(int size1, int size2, String st) {
		int colonIndex = -1;
		String lengthString;
		int sequenceLength = 0;
		int sequenceInteger = 0;

		int commaIndex;
		String workString;

		int res[][] = new int[size1][size2];
		for (int i= 0; i < size1; i++) {
			for (int j= 0; j < size2; j++) {
				if (sequenceLength != 0) {
					res[i][j] = sequenceInteger;
					sequenceLength--;
					continue;
				}
				commaIndex = st.indexOf(',');
				workString = (commaIndex==-1) ? st :
					st.substring(0, commaIndex);
				st = st.substring(commaIndex+1);
				colonIndex = workString.indexOf(':');
				if (colonIndex == -1) {
					res[i][j]=Integer.parseInt(workString);
					continue;
				}
				lengthString =
					workString.substring(colonIndex+1);
				sequenceLength=Integer.parseInt(lengthString);
				workString=workString.substring(0,colonIndex);
				sequenceInteger=Integer.parseInt(workString);
				res[i][j] = sequenceInteger;
				sequenceLength--;
			}
		}
		return res;
	}
	private int yy_acpt[] = {
		/* 0 */ YY_NOT_ACCEPT,
		/* 1 */ YY_NO_ANCHOR,
		/* 2 */ YY_NO_ANCHOR,
		/* 3 */ YY_NO_ANCHOR,
		/* 4 */ YY_NO_ANCHOR,
		/* 5 */ YY_NO_ANCHOR,
		/* 6 */ YY_NO_ANCHOR,
		/* 7 */ YY_NO_ANCHOR,
		/* 8 */ YY_NO_ANCHOR,
		/* 9 */ YY_NO_ANCHOR,
		/* 10 */ YY_NO_ANCHOR,
		/* 11 */ YY_NO_ANCHOR,
		/* 12 */ YY_NO_ANCHOR,
		/* 13 */ YY_NO_ANCHOR,
		/* 14 */ YY_NO_ANCHOR,
		/* 15 */ YY_NO_ANCHOR,
		/* 16 */ YY_NO_ANCHOR,
		/* 17 */ YY_NO_ANCHOR,
		/* 18 */ YY_NO_ANCHOR,
		/* 19 */ YY_NO_ANCHOR,
		/* 20 */ YY_NO_ANCHOR,
		/* 21 */ YY_NO_ANCHOR,
		/* 22 */ YY_NO_ANCHOR,
		/* 23 */ YY_NO_ANCHOR,
		/* 24 */ YY_NO_ANCHOR,
		/* 25 */ YY_NO_ANCHOR,
		/* 26 */ YY_NO_ANCHOR,
		/* 27 */ YY_NO_ANCHOR,
		/* 28 */ YY_NO_ANCHOR,
		/* 29 */ YY_NO_ANCHOR,
		/* 30 */ YY_NO_ANCHOR,
		/* 31 */ YY_NO_ANCHOR,
		/* 32 */ YY_NO_ANCHOR,
		/* 33 */ YY_NO_ANCHOR,
		/* 34 */ YY_NO_ANCHOR,
		/* 35 */ YY_NO_ANCHOR,
		/* 36 */ YY_NO_ANCHOR,
		/* 37 */ YY_NO_ANCHOR,
		/* 38 */ YY_NO_ANCHOR,
		/* 39 */ YY_NO_ANCHOR,
		/* 40 */ YY_NO_ANCHOR,
		/* 41 */ YY_NO_ANCHOR,
		/* 42 */ YY_NO_ANCHOR,
		/* 43 */ YY_NO_ANCHOR,
		/* 44 */ YY_NO_ANCHOR,
		/* 45 */ YY_NO_ANCHOR,
		/* 46 */ YY_NO_ANCHOR,
		/* 47 */ YY_NO_ANCHOR,
		/* 48 */ YY_NOT_ACCEPT,
		/* 49 */ YY_NO_ANCHOR,
		/* 50 */ YY_NO_ANCHOR,
		/* 51 */ YY_NO_ANCHOR,
		/* 52 */ YY_NOT_ACCEPT,
		/* 53 */ YY_NO_ANCHOR,
		/* 54 */ YY_NO_ANCHOR,
		/* 55 */ YY_NOT_ACCEPT,
		/* 56 */ YY_NO_ANCHOR,
		/* 57 */ YY_NO_ANCHOR,
		/* 58 */ YY_NOT_ACCEPT,
		/* 59 */ YY_NO_ANCHOR,
		/* 60 */ YY_NO_ANCHOR,
		/* 61 */ YY_NOT_ACCEPT,
		/* 62 */ YY_NO_ANCHOR,
		/* 63 */ YY_NOT_ACCEPT,
		/* 64 */ YY_NO_ANCHOR,
		/* 65 */ YY_NOT_ACCEPT,
		/* 66 */ YY_NO_ANCHOR,
		/* 67 */ YY_NOT_ACCEPT,
		/* 68 */ YY_NO_ANCHOR,
		/* 69 */ YY_NOT_ACCEPT,
		/* 70 */ YY_NO_ANCHOR,
		/* 71 */ YY_NO_ANCHOR,
		/* 72 */ YY_NO_ANCHOR,
		/* 73 */ YY_NO_ANCHOR,
		/* 74 */ YY_NO_ANCHOR,
		/* 75 */ YY_NO_ANCHOR,
		/* 76 */ YY_NO_ANCHOR,
		/* 77 */ YY_NO_ANCHOR,
		/* 78 */ YY_NO_ANCHOR,
		/* 79 */ YY_NO_ANCHOR,
		/* 80 */ YY_NOT_ACCEPT,
		/* 81 */ YY_NO_ANCHOR,
		/* 82 */ YY_NO_ANCHOR,
		/* 83 */ YY_NO_ANCHOR,
		/* 84 */ YY_NO_ANCHOR,
		/* 85 */ YY_NO_ANCHOR,
		/* 86 */ YY_NO_ANCHOR,
		/* 87 */ YY_NO_ANCHOR,
		/* 88 */ YY_NO_ANCHOR,
		/* 89 */ YY_NO_ANCHOR,
		/* 90 */ YY_NO_ANCHOR,
		/* 91 */ YY_NO_ANCHOR,
		/* 92 */ YY_NO_ANCHOR,
		/* 93 */ YY_NO_ANCHOR,
		/* 94 */ YY_NO_ANCHOR,
		/* 95 */ YY_NO_ANCHOR,
		/* 96 */ YY_NO_ANCHOR,
		/* 97 */ YY_NO_ANCHOR,
		/* 98 */ YY_NO_ANCHOR,
		/* 99 */ YY_NO_ANCHOR,
		/* 100 */ YY_NO_ANCHOR,
		/* 101 */ YY_NO_ANCHOR,
		/* 102 */ YY_NO_ANCHOR,
		/* 103 */ YY_NO_ANCHOR,
		/* 104 */ YY_NO_ANCHOR,
		/* 105 */ YY_NO_ANCHOR,
		/* 106 */ YY_NO_ANCHOR,
		/* 107 */ YY_NO_ANCHOR,
		/* 108 */ YY_NO_ANCHOR,
		/* 109 */ YY_NO_ANCHOR,
		/* 110 */ YY_NO_ANCHOR,
		/* 111 */ YY_NO_ANCHOR,
		/* 112 */ YY_NO_ANCHOR,
		/* 113 */ YY_NO_ANCHOR,
		/* 114 */ YY_NO_ANCHOR,
		/* 115 */ YY_NO_ANCHOR,
		/* 116 */ YY_NO_ANCHOR,
		/* 117 */ YY_NO_ANCHOR,
		/* 118 */ YY_NO_ANCHOR,
		/* 119 */ YY_NO_ANCHOR,
		/* 120 */ YY_NO_ANCHOR,
		/* 121 */ YY_NO_ANCHOR,
		/* 122 */ YY_NO_ANCHOR,
		/* 123 */ YY_NO_ANCHOR,
		/* 124 */ YY_NO_ANCHOR,
		/* 125 */ YY_NO_ANCHOR,
		/* 126 */ YY_NO_ANCHOR,
		/* 127 */ YY_NO_ANCHOR,
		/* 128 */ YY_NO_ANCHOR,
		/* 129 */ YY_NO_ANCHOR,
		/* 130 */ YY_NO_ANCHOR,
		/* 131 */ YY_NO_ANCHOR,
		/* 132 */ YY_NO_ANCHOR,
		/* 133 */ YY_NO_ANCHOR,
		/* 134 */ YY_NO_ANCHOR,
		/* 135 */ YY_NO_ANCHOR,
		/* 136 */ YY_NO_ANCHOR,
		/* 137 */ YY_NO_ANCHOR,
		/* 138 */ YY_NO_ANCHOR,
		/* 139 */ YY_NO_ANCHOR,
		/* 140 */ YY_NO_ANCHOR,
		/* 141 */ YY_NO_ANCHOR,
		/* 142 */ YY_NO_ANCHOR,
		/* 143 */ YY_NO_ANCHOR,
		/* 144 */ YY_NO_ANCHOR,
		/* 145 */ YY_NO_ANCHOR,
		/* 146 */ YY_NO_ANCHOR,
		/* 147 */ YY_NO_ANCHOR,
		/* 148 */ YY_NO_ANCHOR,
		/* 149 */ YY_NO_ANCHOR,
		/* 150 */ YY_NO_ANCHOR,
		/* 151 */ YY_NO_ANCHOR,
		/* 152 */ YY_NO_ANCHOR,
		/* 153 */ YY_NO_ANCHOR,
		/* 154 */ YY_NO_ANCHOR,
		/* 155 */ YY_NO_ANCHOR
	};
	private int yy_cmap[] = unpackFromString(1,65538,
"40:9,18:2,40,18:2,40:18,18,10,39,40,8,40:2,41,16,17,1,40,4,32,6,2,42:10,3,4" +
"0,11,9,12,40,5,43:26,37,40,38,40,44,40,23,29,25,21,14,33,35,26,27,43:2,28,4" +
"3,19,20,36,43,22,31,13,30,43,34,15,24,43,40,7,40:58,45,40:8,43:23,40,43:31," +
"40,43:58,40:2,43:11,40:2,43:8,40,43:53,40,43:68,40:9,43:36,40:3,43:2,40:4,4" +
"3:30,40:56,43:89,40:18,43:7,40:14,45:2,40:46,45:70,40:26,45:2,40:36,43,45,4" +
"3:3,40,43,40,43:20,40,43:44,40,43:7,40:3,43,40,43,40,43,40,43,40,43:18,40:1" +
"3,43:12,40,43:66,40,43:12,40,43:36,40,45:4,40:9,43:53,40:2,43:2,40:2,43:2,4" +
"0:3,43:28,40:2,43:8,40:2,43:2,40:55,43:38,40:2,43,40:7,43:38,40:10,45:17,40" +
",45:23,40,45:3,40,45,40,45:2,40,45,40:11,43:27,40:5,43:3,40:46,43:26,40:5,4" +
"5,43:10,45:8,40:13,42:10,40:6,45,43:71,40:2,43:5,40,43:15,40,43:4,40,43,45:" +
"15,43:2,45:2,40,45:4,40:2,42:10,40:519,45:3,40,43:53,40:2,45,43,45:16,40:3," +
"45:4,40:3,43:10,45:2,40:2,42:10,40:17,45:3,40,43:8,40:2,43:2,40:2,43:22,40," +
"43:7,40,43,40:3,43:4,40:2,45,40,45:7,40:2,45:2,40:2,45:3,40:9,45,40:4,43:2," +
"40,43:3,45:2,40:2,42:10,43:2,40:16,45,40:2,43:6,40:4,43:2,40:2,43:22,40,43:" +
"7,40,43:2,40,43:2,40,43:2,40:2,45,40,45:5,40:4,45:2,40:2,45:3,40:11,43:4,40" +
",43,40:7,42:10,45:2,43:3,40:12,45:3,40,43:7,40,43,40,43:3,40,43:22,40,43:7," +
"40,43:2,40,43:5,40:2,45,43,45:8,40,45:3,40,45:3,40:18,43,40:5,42:10,40:17,4" +
"5:3,40,43:8,40:2,43:2,40:2,43:22,40,43:7,40,43:2,40:2,43:4,40:2,45,43,45:6," +
"40:3,45:2,40:2,45:3,40:8,45:2,40:4,43:2,40,43:3,40:4,42:10,40:18,45:2,40,43" +
":6,40:3,43:3,40,43:4,40:3,43:2,40,43,40,43:2,40:3,43:2,40:3,43:3,40:3,43:8," +
"40,43:3,40:4,45:5,40:3,45:3,40,45:4,40:9,45,40:15,42:9,40:17,45:3,40,43:8,4" +
"0,43:3,40,43:23,40,43:10,40,43:5,40:4,45:7,40,45:3,40,45:4,40:7,45:2,40:9,4" +
"3:2,40:4,42:10,40:18,45:2,40,43:8,40,43:3,40,43:23,40,43:10,40,43:5,40:4,45" +
":7,40,45:3,40,45:4,40:7,45:2,40:7,43,40,43:2,40:4,42:10,40:18,45:2,40,43:8," +
"40,43:3,40,43:23,40,43:16,40:4,45:6,40:2,45:3,40,45:4,40:9,45,40:8,43:2,40:" +
"4,42:10,40:145,43:46,40,43,45,43:2,45:7,40:5,43:6,45:9,40,42:10,40:39,43:2," +
"40,43,40:2,43:2,40,43,40:2,43,40:6,43:4,40,43:7,40,43:3,40,43,40,43,40:2,43" +
":2,40,43:2,40,43,45,43:2,45:6,40,45:2,43,40:2,43:5,40,45,40,45:6,40:2,42:10" +
",40:62,45:2,40:6,42:10,40:11,45,40,45,40,45,40:4,45:2,43:8,40,43:33,40:7,45" +
":20,40,45:6,40:4,45:6,40,45,40,45:21,40:3,45:7,40,45,40:230,43:38,40:10,43:" +
"39,40:9,43,40,43:2,40,43:3,40,43,40,43:2,40,43:5,40:41,43,40,43,40,43,40:11" +
",43,40,43,40,43,40:3,43:2,40:3,43,40:5,43:3,40,43,40,43,40,43,40,43,40:3,43" +
":2,40:3,43:2,40,43,40:40,43,40:9,43,40:2,43,40:2,43:2,40:7,43:2,40,43,40,43" +
":7,40:40,43,40:4,43,40:8,43,40:3078,43:156,40:4,43:90,40:6,43:22,40:2,43:6," +
"40:2,43:38,40:2,43:6,40:2,43:8,40,43,40,43,40,43,40,43:31,40:2,43:53,40,43:" +
"7,40,43,40:3,43:3,40,43:7,40:3,43:4,40:2,43:6,40:4,43:13,40:5,43:3,40,43:7," +
"40:211,45:13,40:4,45,40:68,43,40:3,43:2,40:2,43,40:81,43:3,40:3714,45,40,44" +
",40:25,44:9,45:6,40,45:5,40:11,43:84,40:4,45:2,40:2,45:2,40:2,43:90,40,45:3" +
",40:6,43:40,40:7379,44:20902,40:3162,43:11172,40:10332,0:2")[0];

	private int yy_rmap[] = unpackFromString(1,156,
"0,1:2,2,3,1,4,5,1:3,6,7,8,1:5,9,1:4,10,1:3,11,1:3,11:4,1:2,11,1:2,12,11,13," +
"11:4,14,15,16,17,18,1,19,20,18,21,4,20,22,23,24,25,26,27,28,29,30,31,32,33," +
"34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,11,57," +
"58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82," +
"83,84,85,86,87,88,89,90,91,11,92,93,94,95,96,97,98,99,100,101,102,103,104,1" +
"05,106,107,108,109,110,111,112,113,114,115")[0];

	private int yy_nxt[][] = unpackFromString(116,46,
"1,2,3,4,5,6,7,8,9,10,49,11,12,13,131:2,14,15,16,138,50,141,131,79,131,144,1" +
"31:5,93,53,145,131:2,146,17,18,56,53,59,19,131:2,53,-1:48,20,-1:46,21,-1:43" +
",22,-1:50,23,-1:35,24,-1:12,26,-1:45,27,-1:39,48,-1:2,131,-1:6,131,94,131,-" +
"1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:6,51,-1:35,19,-1:45,24,-1:6,48,-1:2" +
",131,-1:6,131:3,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6" +
",131:3,-1:3,131:13,119,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-" +
"1:3,131:13,122,131:4,-1:5,95,131,95:2,-1,31,-1:3,58,-1:7,57:3,-1:3,57:13,-1" +
",57:4,-1:6,57:2,-1:10,25,-1:39,48,-1:2,131,-1:6,131:3,-1:3,131:3,28,131:9,9" +
"5,131:4,-1:5,95,131,95:2,-1:42,51,-1:4,52:38,29,52:6,-1:3,48,-1:2,131,-1:6," +
"131:3,-1:3,131:2,32,131:2,33,134,131:6,95,131:4,-1:5,95,131,95:2,-1,55:40,3" +
"0,55:4,-1:6,57,-1:6,57:3,-1:3,57:18,-1:5,57:4,-1:3,48,-1:2,131,-1:6,131:3,-" +
"1:3,131:13,95,34,131:3,-1:5,95,131,95:2,-1:17,36,-1:31,48,-1:2,131,-1:6,68," +
"131:2,61,-1,63,131:13,95,131:4,-1:5,95,131,95:2,-1:16,67,-1,63,-1:30,48,-1:" +
"2,131,-1:6,131,70,131,65,-1,80,131:13,95,131:4,-1:5,95,131,95:2,-1:17,37,-1" +
":31,48,-1:2,131,-1:6,131:3,-1:3,131:2,35,131:10,95,131:4,-1:5,95,131,95:2,-" +
"1:17,39,-1:31,48,-1:2,131,-1:6,68,131:2,-1:2,63,131:13,95,131:4,-1:5,95,131" +
",95:2,-1:17,40,-1:31,48,-1:2,131,-1:6,131,70,131,-1:2,80,131:13,95,131:4,-1" +
":5,95,131,95:2,-1:3,48,-1:2,131,-1:6,38,131:2,-1:3,131:13,95,131:4,-1:5,95," +
"131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:3,41,131:9,95,131:4,-1:5,95,1" +
"31,95:2,-1:3,48,-1:2,131,-1:6,131,42,131,-1:3,131:13,95,131:4,-1:5,95,131,9" +
"5:2,-1:3,48,-1:2,131,-1:6,43,131:2,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1" +
":3,48,-1:2,131,-1:6,131:3,-1:3,131:13,95,44,131:3,-1:5,95,131,95:2,-1:3,48," +
"-1:2,131,-1:6,131:3,-1:3,131:13,95,131:2,45,131,-1:5,95,131,95:2,-1:3,48,-1" +
":2,131,-1:6,131:3,-1:3,131:13,95,131:2,46,131,-1:5,95,131,95:2,-1:3,48,-1:2" +
",131,-1:6,131:3,-1:3,131:13,95,47,131:3,-1:5,95,131,95:2,-1:3,48,-1:2,131,-" +
"1:6,98,131:2,-1:3,54,131:12,95,131:4,-1:5,95,131,95:2,-1:16,69,-1,80,-1:30," +
"48,-1:2,131,-1:6,131:3,-1:3,131:9,60,131:3,95,131:4,-1:5,95,131,95:2,-1:3,4" +
"8,-1:2,131,-1:6,62,131:2,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2" +
",131,-1:6,131,64,131,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131" +
",-1:6,131:3,-1:3,131:9,66,131:3,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131," +
"-1:6,131:3,-1:3,71,131:12,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,1" +
"31:3,-1:3,131,72,131:11,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,73," +
"131:2,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:" +
"3,74,131:12,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:" +
"9,75,131:3,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,76,13" +
"1:12,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,77,131:12,9" +
"5,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:9,78,131:3,95" +
",131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131,81,131,-1:3,131:13,95,131" +
":4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:2,82,-1:3,131:13,95,131:4,-1:" +
"5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:2,83,131:10,95,131:4,-1:" +
"5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:12,103,95,131:4,-1:5,95," +
"131,95:2,-1:3,48,-1:2,131,-1:6,135,131:2,-1:3,131:13,95,131:4,-1:5,95,131,9" +
"5:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:8,84,131:4,95,131:4,-1:5,95,131,95" +
":2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:9,133,131:3,95,131:4,-1:5,95,131,95" +
":2,-1:3,48,-1:2,131,-1:6,131,147,131,-1:3,131:13,95,131:4,-1:5,95,131,95:2," +
"-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:3,104,131:9,95,131:4,-1:5,95,131,95:2," +
"-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:6,105,131:6,95,131:4,-1:5,95,131,95:2," +
"-1:3,48,-1:2,131,-1:6,131,85,131,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3" +
",48,-1:2,131,-1:6,131,109,131,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3,48" +
",-1:2,131,-1:6,131:3,-1:3,131:8,110,131:4,95,131:4,-1:5,95,131,95:2,-1:3,48" +
",-1:2,131,-1:6,131:3,-1:3,131:12,111,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2" +
",131,-1:6,131:3,-1:3,131,112,131:11,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2," +
"131,-1:6,131:3,-1:3,137,131:12,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-" +
"1:6,131:3,-1:3,131:10,114,131:2,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131," +
"-1:6,86,131:2,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,1" +
"31:3,-1:3,131:13,95,131,115,131:2,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,13" +
"1:3,-1:3,131:2,155,131:10,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,1" +
"31:3,-1:3,131:11,87,131,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131" +
":3,-1:3,131:8,117,131:4,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131" +
":3,-1:3,131:4,88,131:8,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:" +
"3,-1:3,118,131:12,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:" +
"3,131:13,95,131:2,132,131,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3" +
",131,120,131:11,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3," +
"131:3,139,131:9,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3," +
"131:12,123,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131,1" +
"48,131:11,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:8," +
"125,131:4,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:12" +
",126,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:10,140," +
"131:2,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131,89,131,-1:3,131:1" +
"3,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:12,130,95," +
"131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:8,90,131:4,95,1" +
"31:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:8,91,131:4,95,13" +
"1:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131,92,131,-1:3,131:13,95,131:4," +
"-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:13,121,131:4,-1:5,95," +
"131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:9,108,131:3,95,131:4,-1:5,95," +
"131,95:2,-1:3,48,-1:2,131,-1:6,131,107,131,-1:3,131:13,95,131:4,-1:5,95,131" +
",95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:3,106,131:9,95,131:4,-1:5,95,131" +
",95:2,-1:3,48,-1:2,131,-1:6,131,113,131,-1:3,131:13,95,131:4,-1:5,95,131,95" +
":2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:2,116,131:10,95,131:4,-1:5,95,131,9" +
"5:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131,96,131:11,95,131:4,-1:5,95,131,95:" +
"2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,131:13,124,131:4,-1:5,95,131,95:2,-1:3,4" +
"8,-1:2,131,-1:6,131:3,-1:3,131:9,128,131:3,95,131:4,-1:5,95,131,95:2,-1:3,4" +
"8,-1:2,131,-1:6,131,97,131,-1:3,131:13,95,131:4,-1:5,95,131,95:2,-1:3,48,-1" +
":2,131,-1:6,131:3,-1:3,131:13,127,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-" +
"1:6,131:3,-1:3,131:9,129,131:3,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-" +
"1:6,131:3,-1:3,131:7,99,131:5,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1" +
":6,131:3,-1:3,131,100,131:11,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:" +
"6,131:3,-1:3,131:3,101,102,131:8,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131" +
",-1:6,131:3,-1:3,131:6,136,131:6,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131" +
",-1:6,131:3,-1:3,131:3,142,131:9,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131" +
",-1:6,131:3,-1:3,131:10,143,131:2,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,13" +
"1,-1:6,131:3,-1:3,131:8,149,131:4,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,13" +
"1,-1:6,131:3,-1:3,131:12,150,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:" +
"6,131:3,-1:3,131:13,151,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3," +
"-1:3,131:13,95,131:2,152,131,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-" +
"1:3,153,131:12,95,131:4,-1:5,95,131,95:2,-1:3,48,-1:2,131,-1:6,131:3,-1:3,1" +
"31:8,154,131:4,95,131:4,-1:5,95,131,95:2");

	public java_cup.runtime.Symbol next_token ()
		throws java.io.IOException, 
Exception

		{
		int yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			if (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;
			else yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			if (YY_EOF == yy_lookahead && true == yy_initial) {

return new Symbol(sym.EOF);
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_move_end();
					}
					yy_to_mark();
					switch (yy_last_accept_state) {
					case 1:
						
					case -2:
						break;
					case 2:
						{ return new Symbol(sym.STAR); }
					case -3:
						break;
					case 3:
						{ return new Symbol(sym.SLASH); }
					case -4:
						break;
					case 4:
						{ throw new Exception(yytext()); }
					case -5:
						break;
					case 5:
						{ return new Symbol(sym.COMMA); }
					case -6:
						break;
					case 6:
						{ return new Symbol(sym.ATSIGN); }
					case -7:
						break;
					case 7:
						{ return new Symbol(sym.DOT); }
					case -8:
						break;
					case 8:
						{ return new Symbol(sym.VBAR); }
					case -9:
						break;
					case 9:
						{ return new Symbol(sym.DOLLAR); }
					case -10:
						break;
					case 10:
						{ return new Symbol(sym.EQ); }
					case -11:
						break;
					case 11:
						{ return new Symbol(sym.LT); }
					case -12:
						break;
					case 12:
						{ return new Symbol(sym.GT); }
					case -13:
						break;
					case 13:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -14:
						break;
					case 14:
						{ return new Symbol(sym.LPAREN); }
					case -15:
						break;
					case 15:
						{ return new Symbol(sym.RPAREN); }
					case -16:
						break;
					case 16:
						{ /* ignore white space. */ }
					case -17:
						break;
					case 17:
						{ return new Symbol(sym.LBRACK); }
					case -18:
						break;
					case 18:
						{ return new Symbol(sym.RBRACK); }
					case -19:
						break;
					case 19:
						{ return new Symbol(sym.NUMBER, new Double(yytext())); }
					case -20:
						break;
					case 20:
						{ return new Symbol(sym.DSLASH); }
					case -21:
						break;
					case 21:
						{ return new Symbol(sym.DCOLON); }
					case -22:
						break;
					case 22:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -23:
						break;
					case 23:
						{ return new Symbol(sym.DDOT); }
					case -24:
						break;
					case 24:
						{ return new Symbol(sym.NUMBER, new Double(yytext())); }
					case -25:
						break;
					case 25:
						{ return new Symbol(sym.NE); }
					case -26:
						break;
					case 26:
						{ return new Symbol(sym.LE); }
					case -27:
						break;
					case 27:
						{ return new Symbol(sym.GE); }
					case -28:
						break;
					case 28:
						{ return new Symbol(sym.OR); }
					case -29:
						break;
					case 29:
						{ return new Symbol(sym.LITERAL, yytext().substring(1, yytext().length() - 1)); }
					case -30:
						break;
					case 30:
						{ return new Symbol(sym.LITERAL, yytext().substring(1, yytext().length() - 1)); }
					case -31:
						break;
					case 31:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -32:
						break;
					case 32:
						{ return new Symbol(sym.AND); }
					case -33:
						break;
					case 33:
						{ return new Symbol(sym.ANY); }
					case -34:
						break;
					case 34:
						{ return new Symbol(sym.SELF); }
					case -35:
						break;
					case 35:
						{ return new Symbol(sym.CHILD); }
					case -36:
						break;
					case 36:
						{ return new Symbol(sym.TEXT); }
					case -37:
						break;
					case 37:
						{ return new Symbol(sym.NODE); }
					case -38:
						break;
					case 38:
						{ return new Symbol(sym.PARENT); }
					case -39:
						break;
					case 39:
						{ return new Symbol(sym.TEXT); }
					case -40:
						break;
					case 40:
						{ return new Symbol(sym.NODE); }
					case -41:
						break;
					case 41:
						{ return new Symbol(sym.ANCESTOR); }
					case -42:
						break;
					case 42:
						{ return new Symbol(sym.ATTRIBUTE); }
					case -43:
						break;
					case 43:
						{ return new Symbol(sym.DESCENDANT); }
					case -44:
						break;
					case 44:
						{ return new Symbol(sym.ANCESTORORSELF); }
					case -45:
						break;
					case 45:
						{ return new Symbol(sym.FOLLOWINGSIBLING); }
					case -46:
						break;
					case 46:
						{ return new Symbol(sym.PRECEDINGSIBLING); }
					case -47:
						break;
					case 47:
						{ return new Symbol(sym.DESCENDANTORSELF); }
					case -48:
						break;
					case 49:
						{ throw new Exception(yytext()); }
					case -49:
						break;
					case 50:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -50:
						break;
					case 51:
						{ return new Symbol(sym.NUMBER, new Double(yytext())); }
					case -51:
						break;
					case 53:
						{ throw new Exception(yytext()); }
					case -52:
						break;
					case 54:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -53:
						break;
					case 56:
						{ throw new Exception(yytext()); }
					case -54:
						break;
					case 57:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -55:
						break;
					case 59:
						{ throw new Exception(yytext()); }
					case -56:
						break;
					case 60:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -57:
						break;
					case 62:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -58:
						break;
					case 64:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -59:
						break;
					case 66:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -60:
						break;
					case 68:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -61:
						break;
					case 70:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -62:
						break;
					case 71:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -63:
						break;
					case 72:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -64:
						break;
					case 73:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -65:
						break;
					case 74:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -66:
						break;
					case 75:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -67:
						break;
					case 76:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -68:
						break;
					case 77:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -69:
						break;
					case 78:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -70:
						break;
					case 79:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -71:
						break;
					case 81:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -72:
						break;
					case 82:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -73:
						break;
					case 83:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -74:
						break;
					case 84:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -75:
						break;
					case 85:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -76:
						break;
					case 86:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -77:
						break;
					case 87:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -78:
						break;
					case 88:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -79:
						break;
					case 89:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -80:
						break;
					case 90:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -81:
						break;
					case 91:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -82:
						break;
					case 92:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -83:
						break;
					case 93:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -84:
						break;
					case 94:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -85:
						break;
					case 95:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -86:
						break;
					case 96:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -87:
						break;
					case 97:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -88:
						break;
					case 98:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -89:
						break;
					case 99:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -90:
						break;
					case 100:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -91:
						break;
					case 101:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -92:
						break;
					case 102:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -93:
						break;
					case 103:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -94:
						break;
					case 104:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -95:
						break;
					case 105:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -96:
						break;
					case 106:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -97:
						break;
					case 107:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -98:
						break;
					case 108:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -99:
						break;
					case 109:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -100:
						break;
					case 110:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -101:
						break;
					case 111:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -102:
						break;
					case 112:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -103:
						break;
					case 113:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -104:
						break;
					case 114:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -105:
						break;
					case 115:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -106:
						break;
					case 116:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -107:
						break;
					case 117:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -108:
						break;
					case 118:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -109:
						break;
					case 119:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -110:
						break;
					case 120:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -111:
						break;
					case 121:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -112:
						break;
					case 122:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -113:
						break;
					case 123:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -114:
						break;
					case 124:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -115:
						break;
					case 125:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -116:
						break;
					case 126:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -117:
						break;
					case 127:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -118:
						break;
					case 128:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -119:
						break;
					case 129:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -120:
						break;
					case 130:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -121:
						break;
					case 131:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -122:
						break;
					case 132:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -123:
						break;
					case 133:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -124:
						break;
					case 134:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -125:
						break;
					case 135:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -126:
						break;
					case 136:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -127:
						break;
					case 137:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -128:
						break;
					case 138:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -129:
						break;
					case 139:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -130:
						break;
					case 140:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -131:
						break;
					case 141:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -132:
						break;
					case 142:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -133:
						break;
					case 143:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -134:
						break;
					case 144:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -135:
						break;
					case 145:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -136:
						break;
					case 146:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -137:
						break;
					case 147:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -138:
						break;
					case 148:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -139:
						break;
					case 149:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -140:
						break;
					case 150:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -141:
						break;
					case 151:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -142:
						break;
					case 152:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -143:
						break;
					case 153:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -144:
						break;
					case 154:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -145:
						break;
					case 155:
						{ return new Symbol(sym.QNAME, yytext()); }
					case -146:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
						yy_mark_end();
					}
				}
			}
		}
	}
}
