package org.planx.xmlstore.regions;

import java.io.*;
import java.util.*;
import org.planx.xmlstore.*;
import org.planx.xmlstore.io.*;
import org.planx.xmlstore.nodes.*;
import org.planx.util.*;
import static org.planx.xmlstore.regions.RegionConfiguration.*;

public abstract class Sharer {
    protected RegionManager manager;

    // Background task fields
    protected Timer timer = null;
    protected TimerTask bgTask = null;

    // Statistics
    protected boolean isDiscriminated = true;
    protected boolean isIterated = true;
    protected int invocations = 0;

    Sharer(RegionManager manager) {
        this.manager = manager;
    }

    /**
     * Starts the <code>Sharer</code> background thread with the period between runs
     * specified in the constructor.
     */
    public synchronized void start() {
        // Schedule recurring sharer invocation
        timer = new Timer(true);                    // as daemon thread
        bgTask = new TimerTask() {
            public void run() {
                try {
                    synchronized (Sharer.this.manager) {
                        share();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        long period = manager.configuration().SHARER_PERIOD;
        timer.schedule(bgTask, period, period);
    }

    /**
     * Stops the <code>Sharer</code> background thread.
     */
    public synchronized void stop() {
        if (bgTask != null) bgTask.cancel();
        if (timer != null) timer.cancel();
    }

    public synchronized boolean isDiscriminated() {
        return isDiscriminated;
    }

    public synchronized boolean isIterated() {
        return isIterated;
    }

    public synchronized int invocations() {
        return invocations;
    }

    abstract void addRegion(Region newRegion) throws IOException,
                                UnknownReferenceException;

    abstract void removeRegion(Region region);

    public abstract void share() throws IOException,
                                UnknownReferenceException;
}
