package org.planx.msd.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.planx.msd.*;
import org.planx.msd.util.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset
 * of <code>EquivalenceClassDiscriminable</code> objects.
 * <p>
 * <b>Note that this implementation is not synchronized.</b> If multiple
 * threads access <i>any</i> instance of this class concurrently,
 * <i>all</i>  <code>EquivalenceClassDiscriminable</code> objects
 * to be discriminated must be synchronized externally.
 *
 * @author Thomas Ambus
 */
public class EquivalenceClassDiscriminator<T extends
                             EquivalenceClassDiscriminable>
                             extends AbstractDiscriminator<T> {

    private final EquivalenceClass NULL_CLASS = new EquivalenceClass();

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                              Extractor<U,? extends T,S> e) {
        // Keeps track of which EquivalenceClasses are used
        List<EquivalenceClass> eqClasses = new ArrayList<EquivalenceClass>();

        for (U elm : values) {
            T label = e.getLabel(elm);
            EquivalenceClass eqCls = (label == null) ? NULL_CLASS :
                    label.getEquivalenceClass();
            if (eqCls.isEmpty()) eqClasses.add(eqCls);
            eqCls.add(e.getValue(elm));
        }

        Collection<List<S>> result = new ArrayList<List<S>>(
                                            eqClasses.size());
        for (EquivalenceClass eqCls : eqClasses) {
            List<S> group = eqCls.getListAndClear();
            result.add(group);
        }
        return result;
    }
}
