/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.dir.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ops4j.lang.NullArgumentException;

public class Parser {
    private static final String SYNTAX = "dir:local-file-uri[$building-m_options]";
    private static final String OPTION_SEPARATOR = "&";
    private static final String TAIL = "tail";
    private static final String INSTRUCTIONS_SEPARATOR = "$";
    private static final Pattern SYNTAX_JAR_INSTR = Pattern.compile("(.+?)\\$(.+?)");
    private File m_directory;
    private Properties m_options = new Properties();

    public Parser(String url) {
        NullArgumentException.validateNotNull(url, "url should be provided");
        try {
            URL originalURL = new URL(url);
            Matcher matcher = SYNTAX_JAR_INSTR.matcher(originalURL.getPath());
            if (matcher.matches()) {
                this.m_directory = this.toLocalFile(matcher.group(1));
                this.parseOptions(matcher.group(2));
            } else {
                this.m_directory = this.toLocalFile(originalURL.getPath());
            }
            this.verifyDirectory();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("path is not nice.", e);
        }
    }

    File toLocalFile(String s) throws IOException {
        return new File(s);
    }

    private void verifyDirectory() {
        NullArgumentException.validateNotNull(this.m_directory, "path should be a valid file");
        try {
            if (!this.m_directory.exists()) {
                throw new IllegalArgumentException("Folder " + this.m_directory.getAbsolutePath() + " does not exist on local filesystem");
            }
            if (!this.m_directory.isDirectory()) {
                throw new IllegalArgumentException("Path " + this.m_directory.getCanonicalPath() + " does not refer to a folder");
            }
        }
        catch (IOException ioE) {
            throw new IllegalArgumentException(this.m_directory.getAbsolutePath() + " is not valid: ", ioE);
        }
    }

    public File getDirectory() {
        return this.m_directory;
    }

    private void parseOptions(String s) {
        StringTokenizer tk = new StringTokenizer(s, OPTION_SEPARATOR);
        while (tk.hasMoreTokens()) {
            StringTokenizer inner = new StringTokenizer(tk.nextToken(), "=");
            String key = inner.nextToken();
            String value = "";
            if (inner.hasMoreTokens()) {
                value = inner.nextToken();
            }
            this.m_options.put(key, value);
        }
    }

    public Properties getOptions() {
        return this.m_options;
    }

    public String getTailExpr() {
        return (String)this.m_options.get(TAIL);
    }
}

