/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.ops4j.io.ListerUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.assembly.internal.Source;

public class ImmutableSource
implements Source {
    private final String m_path;
    private final Pattern[] m_includes;
    private final Pattern[] m_excludes;

    public ImmutableSource(String path, Pattern[] includes, Pattern[] excludes) {
        Pattern[] patternArray;
        NullArgumentException.validateNotEmpty(path, true, "Path");
        this.m_path = path;
        if (includes == null || includes.length == 0) {
            Pattern[] patternArray2 = new Pattern[1];
            patternArray = patternArray2;
            patternArray2[0] = ListerUtils.parseFilter("**");
        } else {
            patternArray = includes;
        }
        this.m_includes = patternArray;
        this.m_excludes = excludes == null ? new Pattern[]{} : excludes;
    }

    public String path() {
        return this.m_path;
    }

    public Pattern[] includes() {
        return this.m_includes;
    }

    public Pattern[] excludes() {
        return this.m_excludes;
    }

    public String toString() {
        return String.format("%s includes(%s) excludes(%s)", this.m_path, Arrays.deepToString(this.m_includes), Arrays.deepToString(this.m_excludes));
    }
}

