/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.signature;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.signature.MoleculeSignature;
import signature.AbstractQuotientGraph;

public class SignatureQuotientGraph
extends AbstractQuotientGraph {
    private IAtomContainer atomContainer;

    public SignatureQuotientGraph(IAtomContainer atomContainer) {
        this(atomContainer, -1);
    }

    public SignatureQuotientGraph(IAtomContainer atomContainer, int height) {
        this.atomContainer = atomContainer;
        MoleculeSignature moleculeSignature = new MoleculeSignature(atomContainer);
        super.construct(moleculeSignature.getSymmetryClasses(height));
    }

    public boolean isConnected(int index1, int index2) {
        IAtom atom2;
        IAtom atom1 = this.atomContainer.getAtom(index1);
        return this.atomContainer.getBond(atom1, atom2 = this.atomContainer.getAtom(index2)) != null;
    }
}

