package org.nuiton.wikitty.publication.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class WikittyPubTextCompiledAbstract extends BusinessEntityImpl implements WikittyPubTextCompiled {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyPubTextCompiled;
    /**
     * getByteCode :
     * @return byte[] 
     */

    @Override
    public byte[] getByteCode() {
        byte[] value = WikittyPubTextCompiledHelper.getByteCode(getWikitty());
        return value;
}

    /**
     * setByteCode :
     * @param byteCode 
     */

    @Override
    public void setByteCode(byte[] byteCode) {
        byte[] oldValue = getByteCode();
        WikittyPubTextCompiledHelper.setByteCode(getWikitty(), byteCode);
        getPropertyChangeSupport().firePropertyChange(WikittyPubTextCompiled.FIELD_WIKITTYPUBTEXTCOMPILED_BYTECODE, oldValue, getByteCode());
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        String value = WikittyPubTextHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    public void setName(String name) {
        String oldValue = getName();
        WikittyPubTextHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(WikittyPubText.FIELD_WIKITTYPUBTEXT_NAME, oldValue, getName());
}

    /**
     * getMimeType :
     * @return String 
     */

    public String getMimeType() {
        String value = WikittyPubTextHelper.getMimeType(getWikitty());
        return value;
}

    /**
     * setMimeType :
     * @param mimeType 
     */

    public void setMimeType(String mimeType) {
        String oldValue = getMimeType();
        WikittyPubTextHelper.setMimeType(getWikitty(), mimeType);
        getPropertyChangeSupport().firePropertyChange(WikittyPubText.FIELD_WIKITTYPUBTEXT_MIMETYPE, oldValue, getMimeType());
}

    /**
     * getContent :
     * @return String 
     */

    public String getContent() {
        String value = WikittyPubTextHelper.getContent(getWikitty());
        return value;
}

    /**
     * setContent :
     * @param content 
     */

    public void setContent(String content) {
        String oldValue = getContent();
        WikittyPubTextHelper.setContent(getWikitty(), content);
        getPropertyChangeSupport().firePropertyChange(WikittyPubText.FIELD_WIKITTYPUBTEXT_CONTENT, oldValue, getContent());
}

    /**
     * WikittyPubTextCompiledAbstract :
     */

    public WikittyPubTextCompiledAbstract() {
        super();
}

    /**
     * WikittyPubTextCompiledAbstract :
     * @param wikitty 
     */

    public WikittyPubTextCompiledAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyPubTextCompiledAbstract :
     * @param businessEntityImpl 
     */

    public WikittyPubTextCompiledAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyPubTextCompiled =
                new WikittyExtension(EXT_WIKITTYPUBTEXTCOMPILED,
                                     "1.0", // version
                                     WikittyPubText.EXT_WIKITTYPUBTEXT,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Binary byteCode unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyPubTextAbstract.extensions); 
        // current after requires ones

        exts.add(extensionWikittyPubTextCompiled);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyPubTextCompiledAbstract
