/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.publication.ActionError;
import org.nuiton.wikitty.publication.WikittyPublicationAction;
import org.nuiton.wikitty.publication.WikittyPublicationContext;

public class WikittyPublicationServlet
extends HttpServlet {
    public static ApplicationConfig appConfig;
    private static Log log;

    public void init() throws ServletException {
        try {
            appConfig = new ApplicationConfig();
            appConfig.setConfigFileName("wikitty-publication.properties");
            appConfig.parse(null);
        }
        catch (ArgumentsParserException eee) {
            throw new ServletException("Can't get filename config prefix", (Throwable)eee);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object result;
        WikittyPublicationContext context = new WikittyPublicationContext(appConfig);
        try {
            context.parse(req, resp);
            if ("true".equals(context.getArguments().get("debug"))) {
                result = context.toString();
                context.setContentType("text/plain");
            } else {
                WikittyPublicationAction action = context.getAction();
                result = action.doAction(context);
            }
        }
        catch (Throwable eee) {
            ActionError action = new ActionError(eee);
            result = action.doAction(context);
        }
        String contentType = context.getContentType();
        if (contentType != null && contentType.startsWith("forward")) {
            req.getRequestDispatcher(String.valueOf(result)).forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            Object out;
            if (contentType != null) {
                resp.setContentType(contentType);
            }
            if (result instanceof byte[]) {
                out = resp.getOutputStream();
                out.write((byte[])result);
                out.flush();
            } else {
                out = resp.getWriter();
                ((PrintWriter)out).write(String.valueOf(result));
                ((PrintWriter)out).flush();
            }
        }
    }

    static {
        log = LogFactory.getLog(WikittyPublicationServlet.class);
    }
}

